<?php
// Copyright (c) 2009 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: posts.php f5c9a6e80742 2009/10/16 09:18:54 Oliver Lau <oliver@von-und-fuer-lau.de> $
header('Content-type: text/x-json');
include('../globals.inc.php');

$d = '';
$fp = fopen('php://input', 'rb');
while (!feof($fp))
    $d .= fread($fp, 512);
fclose($fp);
if (!get_magic_quotes_gpc())
    $d = stripslashes($d);
$jsonArray = json_decode($d);

if (!$jsonArray) {
    echo json_encode(array(
          'status' => E_INVALID_REQUEST,
          'message' => 'Invalid or missing data.',
          'data' => $d
         ));
    exit;
}

$dbh = dbpconnect('.');

$posts = array();

$dbh->exec('BEGIN TRANSACTION');
$sql = 'SELECT id, url, created_at, author, title, body FROM posts WHERE id = ?';
$sth = $dbh->prepare($sql);

foreach($jsonArray as $id) {
   $rs = $sth->execute(array($id));
   if (!$rs) {
       echo json_encode(array(
             'status' => E_INVALID_REQUEST,
             'message' => 'sth->execute() failed.',
             'data' => $d
            ));
       exit;
   }
   while ($row = $sth->fetch(PDO::FETCH_ASSOC))
     array_push($posts, array(
         'id' => $row['id'],
         'url' => $row['url'],
         'created_at' => $row['created_at'],
         'author' => $row['author'],
         'title' => $row['title'],
         'body' => $row['body']
     ));
}
$dbh->exec('END TRANSACTION');

print json_encode($posts);
?>