Set wmi = GetObject("winmgmts:")
Set cpu = wmi.InstancesOf("Win32_Processor",48)
Set board = wmi.InstancesOf("Win32_BaseBoard",48)
Set bios = wmi.InstancesOf("Win32_BIOS",48)
Set ide = wmi.InstancesOf("Win32_IDEController",48)
Set scsi = wmi.InstancesOf("Win32_SCSIController",48)
Set usb = wmi.InstancesOf("Win32_USBController",48)

inConsole = ("CSCRIPT.EXE" = UCase(Right(WScript.Fullname, 11 )))
result = ""

bFirst = True
For Each objInstance In cpu
  If Not bFirst Then result = result & vbCrLf
  bFirst = False
  With objInstance
    AddValue "CPU ",         .Name
    AddValue "CPU-Herst.",   .Manufacturer
    AddValue "Beschreibung", .Description
    Select Case .DataWidth
      Case 64
        AddValue "x86 oder x64", "x64"
      Case 32
        AddValue "x86 oder x64", "x86"
      Case Else
        AddValue "x86 oder x64", .DataWidth
    End Select
    AddValue "Takt max.",    .MaxClockSpeed & " MHz"
    AddValue "Takt aktuell", .CurrentClockSpeed & " MHz"
    AddValue "L2-Cache",     .L2CacheSize & " MByte"
    AddValue "ext. Takt",    .ExtClock & " MHz"
    AddValue "CPUID",        .ProcessorID
    AddValue "CPU-Stepping", .Stepping
  End With
Next

PrintLine

For Each objInstance In board
  With objInstance
    AddValue "Mainboard", .Manufacturer
    AddValue "Typ ",      .Product
  End With
Next

For Each objInstance In bios
  With objInstance
    AddValue "BIOS ",        .Manufacturer
    AddValue "BIOS-Version", .SMBIOSBIOSVersion
    AddValue "BIOS-Datum",   .ReleaseDate
  End With
Next

PrintLine

bFirst = True
For Each objInstance In ide
  If Not bFirst Then result = result & vbCrLf
  bFirst = False
  With objInstance
    AddValue "IDE-Adapter", .Manufacturer
    AddValue "Description", .Description
    AddValue "DeviceID",    .DeviceID
  End With
Next

PrintLine

bFirst = True
For Each objInstance In scsi
  If Not bFirst Then result = result & vbCrLf
  bFirst = False
  With objInstance
    AddValue "SCSI-Adapter", .Manufacturer
    AddValue "Description",  .Description
    AddValue "DeviceID",     .DeviceID
  End With
Next

PrintLine

bFirst = True
For Each objInstance In usb
  If Not bFirst Then result = result & vbCrLf
  bFirst = False
  With objInstance
    AddValue "USB-Adapter", .Manufacturer
    AddValue "Description", .Description
    AddValue "DeviceID",    .DeviceID
  End With
Next

WScript.Echo result

'=============================

Sub AddValue (descript, value)
  If inConsole Then
    result = result & Left(descript & String(12, " "), 12) & " : "
  Else
    result = result & descript & ":" & String(13 - Len(RTrim(descript)), " ") & vbTab
  End If
  result = result & value & vbCrLf
End Sub

Sub PrintLine
  If inConsole Then
    WScript.Echo result
    WScript.Echo String(75, "-") & vbCrLf
    result = ""
  Else
    result = result & String(100, "-") & vbCrLf
  End If
End Sub
