' DhcpToPCListe.vbs 1.0 von Robert Hohmann 07/2009
' Erstellt aus einem DHCP-Export die PCListe.txt fr das MaschinenStopp-Skript

Set fs = CreateObject("Scripting.FileSystemObject")

Dim tabstopp(20)

pos1 = InstrRev(WScript.ScriptFullName, "\")
path = Left(WScript.ScriptFullName, pos1)

Set PCListeTemp = fs.OpenTextFile("PCListe-temp.txt", 2, true)   ' Ausgabedatei

If Wscript.Arguments.Count = 0 Then 
  wscript.echo "DhcpToPCListe.vbs 1.0 von Robert Hohmann 07/2009"
  wscript.echo "Erstellt aus einem DHCP-Export die PCListe.txt fr das MaschinenStopp-Skript"
  wscript.echo "Syntax: cscript DhcpToPCListe.vbs <DHCP-Export-Datei> [<zu entfernende Zeichen>]"
  wscript.quit
End If
filename = Wscript.Arguments(0)
If Wscript.Arguments.Count = 2 Then deletestring = Wscript.Arguments(1)   ' zu entfernende Zeichen, z.B. Domnen-Suffix
Set DHCPListe = fs.OpenTextFile(filename, 1, true)					


' berflssigen Text entfernen, so dass nur PC-Name und MAC-Adresse brig bleiben:
Do Until DHCPListe.AtEndOfStream
  zeile = Trim(DHCPListe.ReadLine)
  If Len(zeile) > 10 and InStr(zeile,"DHCP") Then 
      laenge = Len(zeile)
      tabstopp_zaehler = 0
      For i = 1 to laenge
        buchstabe = Mid(zeile,i,1)
        If Asc(buchstabe) = 9 Then 
          tabstopp_zaehler = tabstopp_zaehler + 1
          tabstopp(tabstopp_zaehler) = i + 1
        End If
      Next
      hostname = Mid(zeile, tabstopp(1), tabstopp(2)-tabstopp(1)-1)
      If deletestring <> "" Then
        If InStr(hostname,deletestring) Then
          hostname = Left(hostname,InStr(hostname,deletestring)-1)
        End If
      End If
      mac = Mid(zeile, tabstopp(4), tabstopp(5)-tabstopp(4)-1)
      PCListeTemp.Writeline hostname & Chr(9) & mac
  End If
loop
wscript.echo "Datei PCListe-temp.txt erstellt"
