' Setup.vbs fr WakeupService 1.1
' von Robert Hohmann 06/2009

On Error Resume Next

Set Reg = GetObject("winmgmts:root\Default:StdRegProv")
Set Shell = CreateObject("Wscript.Shell")
Set fs = CreateObject("Scripting.FileSystemObject")
Set Env = Shell.Environment("Process")
Set oDrives = fs.Drives
pos1 = InstrRev(WScript.ScriptFullName, "\")
setuppath = Left(WScript.ScriptFullName, pos1)
Set LogFile = fs.OpenTextFile(setuppath & "\installation.log", 8, true)


Const HKEY_LOCAL_MACHINE = &H80000002


Call logging("===============================================")
Call logging("WakeupService-Installation wird gestartet...")

'***************************************************************************************************************************
' Get install path
'***************************************************************************************************************************
Do
  path = inputbox("Installationspfad","WakeupService Installation","C:\WakeupService")
  check = true
  If path = "" Then
    MsgBox "Installation durch Anwender abgebrochen."
    Call logging("Installation durch Anwender abgebrochen.")
    WScript.Quit	
  End if
  If fs.FolderExists(path) Then
    MsgBox "Pfad existiert bereits."
    check = false
  End If	
  If InStr(path," ") Then 
    MsgBox "Bitte Pfad ohne Leerzeichen angeben!"
    check = false
  End If
  If Len(path) < 4 Then 
    MsgBox "Ungltiger Pfad."
    check = false
  End If
loop until check = true

Call logging("Installationspfad ist " & path)



result = fs.CreateFolder(path)
If err.number = 0 then
    Call logging("Erstellung von Verzeichnis " & path & " erfolgreich.")        	
Else
    Call logging("Erstellung von Verzeichnis " & path & " fehlgeschlagen.")        	
    MsgBox "Erstellung von Verzeichnis " & path & " fehlgeschlagen."      	        
    Call logging("Sie bentigen Administratorrechte fr diese Installation.")        	
    call cleanup
    WScript.Quit
End if
result = fs.CreateFolder(path & "\PCs")
If err.number = 0 then
    Call logging("Erstellung von Verzeichnis " & path & "\PCs" & " erfolgreich.")        	
Else
    Call logging("Erstellung von Verzeichnis " & path & "\PCs" & " fehlgeschlagen.")        	
    MsgBox "Erstellung von Verzeichnis " & path & "\PCs" & " fehlgeschlagen."      	        
    Call logging("Sie bentigen Administratorrechte fr diese Installation.")        	
    call cleanup
    WScript.Quit
End if    
result = fs.CreateFolder(path & "\conf")
If err.number = 0 then
    Call logging("Erstellung von Verzeichnis " & path & "\conf" & " erfolgreich.")        	
Else
    Call logging("Erstellung von Verzeichnis " & path & "\conf" & " fehlgeschlagen.")        	
    MsgBox "Erstellung von Verzeichnis " & path & "\conf" & " fehlgeschlagen."      	        
    Call logging("Sie bentigen Administratorrechte fr diese Installation.")        	
    call cleanup
    WScript.Quit
End if


'***************************************************************************************************************************
' Copy Files
'***************************************************************************************************************************
If not fs.FileExists(setuppath & "\WakeupService.exe") Then 
    Call logging("WakeupService.exe fehlt!")
    MsgBox "WakeupService.exe fehlt!"
    abort = 1
End If
If not fs.FileExists(setuppath & "\WakeupService.vbs") Then 
    Call logging("WakeupService.vbs fehlt!")
    MsgBox "WakeupService.vbs fehlt!"
    abort = 1
End If
If not fs.FileExists(setuppath & "\WakeupService.cfg") Then 
    Call logging("WakeupService.cfg fehlt!")
    MsgBox "WakeupService.cfg fehlt!"
    abort = 1
End If
If not fs.FileExists(setuppath & "\GetMacAddress.vbs") Then 
    Call logging("GetMacAddress.vbs fehlt!")
    MsgBox "GetMacAddress.vbsfehlt!"
    abort = 1
End If
If not fs.FileExists(setuppath & "\Exclude.txt") Then 
    Call logging("Exclude.txt fehlt!")
    MsgBox "Exclude.txt fehlt!"
    abort = 1
End If
If not fs.FileExists(setuppath & "\wol.exe") Then 
    Call logging("wol.exe fehlt!")
    MsgBox "wol.exe fehlt!"
    abort = 1
End If

If abort > 0 Then 
    MsgBox "Installation abgebrochen! Bitte klicken Sie auf OK fr die Installations-Logdatei."
    If abort = 1 Then Call cleanup
    result = shell.Run("cmd.exe /c notepad.exe " & setuppath & "\installation.log", 0, False)
    WScript.Quit
End If

fs.CopyFile setuppath & "\WakeupService.exe", path & "\WakeupService.exe"
fs.CopyFile setuppath & "\WakeupService.vbs", path & "\WakeupService.vbs"
fs.CopyFile setuppath & "\WakeupService.cfg", path & "\WakeupService.cfg"
fs.CopyFile setuppath & "\GetMacAddress.vbs", path & "\GetMacAddress.vbs"
fs.CopyFile setuppath & "\Exclude.txt", path & "\Exclude.txt"
fs.CopyFile setuppath & "\wol.exe", path & "\wol.exe"

wscript.Sleep 2000

Call logging("Dateien erfolgreich kopiert.")
MsgBox "Dateien erfolgreich kopiert." & Chr(13) & Chr(13) & "Klicken Sie auf OK zur Erstellung des geplanten Tasks..."
wscript.Sleep 1000


'***************************************************************************************************************************
' Install Scheduled Tasks
'***************************************************************************************************************************

' Language detection
strComputer = "."
Set objWMIService = GetObject("winmgmts:" _
    & "{impersonationLevel=impersonate}!\\.\root\cimv2")

Set colOperatingSystems = objWMIService.ExecQuery _
    ("Select * from Win32_OperatingSystem")

For Each objOperatingSystem in colOperatingSystems
    If objOperatingSystem.OSLanguage = 1031 Then sprache = "deutsch"
    If objOperatingSystem.OSLanguage = 1033 Then sprache = "englisch"
Next

If sprache = "deutsch" Then intervall = "MINUTE"
If sprache = "englisch" Then intervall = "MINUTE"
Call logging("Betriebssystemsprache ist " & sprache)


konto = inputbox("Sie bentigen ein Benutzerkonto, unter dessen Kontext der geplante Task ausgefhrt wird. Dabei kann es sich um ein lokales oder ein Domnenkonto handeln." & Chr(13) & Chr(13) & "Beispiel: Rechner1\Administrator" & Chr(13) & Chr(13) & "Vista/Server 2008: Bitte Konto des aktuell angemeldeten Benutzers eingeben." & Chr(13) & Chr(13) & "Bitte geben Sie das Benutzerkonto an:")
If konto = "" Then
  MsgBox "Installation durch Anwender abgebrochen."
  Call logging("Installation durch Anwender abgebrochen.")
  Call cleanup
  WScript.Quit
End If
Call logging("Benutzerkonto ist " & konto)
wscript.Sleep 1000

MsgBox "Der geplante Task wird jetzt erstellt. Sie werden whrend der Installation" & Chr(13) & "aufgefordert, das Kennwort fr das von Ihnen angegebene Benutzerkonto" & Chr(13) & "einzugeben (nur unter XP/Server 2003)."
task = "SCHTASKS /Create /RU " & konto & " /SC " & intervall & " /ST 00:00:00 /TN WakeupService /TR " & Chr(34) & "wscript.exe " & path & "\WakeupService.vbs" & Chr(34)
result = shell.Run(task, 1, True)
Call logging("Taskerstellung mit: " & task)
If result <> 0 Then
  MsgBox "Fehler bei der Erstellung des Geplanten Tasks."
  Call logging("Fehler bei der Erstellung des Geplanten Tasks.")
  WScript.Quit  
End if 



'***************************************************************************************************************************
' Complete Installation
'***************************************************************************************************************************
Call logging("WakeupService-Installation erfolgreich.")
MsgBox "WakeupService-Installation erfolgreich." & Chr(13) & Chr(13) & "Bitte klicken Sie auf OK, um die nchsten Schritte anzuzeigen." 

result = shell.Run("cmd.exe /c notepad.exe " & setuppath & "\NextSteps.txt", 0, False)



Sub logging(logtext)
    LogFile.writeline Date & " " & Time & "   " & logtext
End Sub

Sub cleanup
    LogFile.Close
    Set fs = CreateObject("Scripting.FileSystemObject")
    result = fs.DeleteFolder(path)
End Sub

