#!/bin/bash
#
# Überwacht das LAN auf aktive Rechner und
# fährt den Server runter, wenn niemand mehr
# im LAN aktiv ist
#
# Reiko Kaps <rek@ct.de> 2009
#
# Redaktion c't / heise netze 
# http://ct.de
# http://www.heisenetze.de

# Ping-Befehl mit Parametern
# hier: sendet zwei Anfragen
PING="ping -c 2"

# Liste der zu testenden Adressen
# nicht zu überprüfende lassen
# sich auskommentieren
HOSTS=`grep -v ^# <<!
192.168.1.200
192.168.1.40
192.168.1.250
#192.168.1.254
192.168.1.41
!`

# Interval in Seconds
INTERVAL=120

# Check from hour to hour
TIME2CHECK="15 16 17 18 19 20 21 22 23"

# Dummy für den Zustand
ACTIVE=false

# shotdown- oder sleep-Befehl samt Parameter
# *BITTE anpassen* /bin/true ist zum testen gedacht!
#
# CMD="/sbin/shutdown -h"
# CMD="/sbin/halt"
# CMD="/usr/sbin/pm-suspend"
# CMD="/usr/sbin/pm-powersave"
CMD="/bin/true"

# 1 == an, '' == aus
#DEBUG=1

# Lockfile enthält Prozess-ID (PID)
BASENAME=`basename $0`
LOCKFILE="/var/run/${BASENAME}.pid"

##
# überprüfe host-list
function checkhosts()
{

ACTIVE=false

for ADDR in ${HOSTS}
do
  ${PING} ${ADDR} > /dev/null
  if [ $? -eq 0 ]
   then
    [ ${DEBUG} ] && echo $0": "${ADDR}" ist aktiv!"
    ACTIVE=true
    continue
   else
    [ ${DEBUG} ] && echo $0": "${ADDR}" nicht aktiv!"
   fi
done

##
# ist ACTIVE noch 0, sind alle Rechner aus?
if [ "${ACTIVE}" = "false" ]
then
 # schaltet Rechner ab, falls keine lokalen/SSH-Nutzer da sind
 [ ${DEBUG} ] && echo $0": keine LAN-Rechner aktiv, schaltet Server aus"
 logger -t $0 "keine LAN-Rechner aktiv, schaltet Server ab..."
 abschalten
else
 [ ${DEBUG} ] && echo $0": Tue nichts, LAN-Rechner aktiv!"
fi

} 

##
# Schaltet Rechner aus, legt ihn schlafen
function abschalten()
{
  [ ${DEBUG} ] && echo "Führe Kommando $CMD aus ..."
  logger -t $0 "Schalte Rechner mit Kommando ${CMD} aus."
  ${CMD} 
}

## 
# Überprüfe auf lokal oder per SSH angemeldete Nutzer
# berücksichtigt auch Screen-Sitzungen!
function localUsers()
{
  COUNT=`w -h | sed '/^\s*$/d' | wc -l`
  [ $DEBUG ] && echo "$0: Lokale Benutzer: $COUNT "
  return ${COUNT}
}

##
# Hauptprogramm

# Dauerschleife bis Strg-C, kill, killall ...
# Aufräumarbeiten erledigt das Trap-Kommando oben

case "$1" in 
    start)
        echo -ne "Starting $0 "
	$0 run & 
	while [ ! -e ${LOCKFILE} ]
	do
	  echo -ne "."
	  sleep 2
	done
	echo "(PID: "`cat ${LOCKFILE}`")."
	exit 
	;;
    stop)
        if [ -e ${LOCKFILE} ]
	then
	  CPID=`cat ${LOCKFILE}`
	  echo -ne "Stopping $0 with PID $CPID "
	  # beenden mit SIGTERM,
	  # warte bis PID-File entfernt ist
	  while [ -e ${LOCKFILE} ]
	  do
	     echo -ne "."
	     kill ${CPID}
	     sleep 2
	  done
	  echo "[done]"
    
	else
	  echo "$0 is not running."
	  exit
	fi	  
	;;
    restart)
        $0 stop ; $0 start
	;;
    run)
    if [ -e ${LOCKFILE} ]
    then 
      CPID=`cat ${LOCKFILE}`
      echo "Programm lauft bereits. (PID: ${CPID})"
      exit -1
    else
      # PID File samt PID speichern
      # wird via trap am Programm-Ende wieder
      # entsorgt
      echo $$ > ${LOCKFILE}
      trap "rm -f ${LOCKFILE}; exit" INT TERM EXIT
    fi
    
    # foreground
    while true
    do
      for hour in ${TIME2CHECK}
      do
        if [ `date +%H` -eq ${hour} ]
	then
	  [ $DEBUG ] && echo "$0: Zeit zum Einschlafen ($hour Uhr), starte Tests ..."
	  logger -t $0 "Zeit zum Einschlafen, starte Tests ..."
	  # falls wer angemeldet ist, wird nichts weiter getan
	  localUsers
	  if [ $? -eq 0 ]
	  then checkhosts 
	  else logger -t $0 " $? lokale Nutzer angemeldet, stoppe hier!"
	  fi
	else
	  [ $DEBUG ] && echo "$0: Tue nichts ... ($hour Uhr) ..."
	  logger -t $0 "Tue nichts ..."
	  continue
	fi
      done
      sleep $INTERVAL
    done	
	;;
    *)
	echo "usage: $0 start|stop|restart|run"
	echo "options:"
	echo "  start: runs program in background"
	echo "   stop: stops background program"
	echo "restart: restart a already running instance"
	echo "    run: run program in foreground, stopps with Strg-C"
	exit
	;;
esac

