/** This code will ONLY compile with C++0x, because it uses a small new bit:
* It will not compile with c++98 because the PrintOp functor can not
* be used as a template argument, because it is defined locally.
*/
#include <vector>
#include <iostream>
#include <algorithm>
using namespace std;

//:begin
static void printAll(vector<int> &v) {
	struct PrintOp {
		void operator()(int i) { cout<<i<<" "; }
	};
	for_each(v.begin(), v.end(), PrintOp());  //! local functor as templ arg
	cout << endl;
}

//:end

int main() {
	std::cerr << "=== " << __FILE__ << " ===" << std::endl;
	vector<int> vec;
	for(int i=0; i<10; ++i)
		vec.push_back(i*i);
	printAll(vec);

	return EXIT_SUCCESS;
}
