// sequence constructor demo, using a list of doubles, 
//   also demonstrating unified initialization

#include <string>
#include <vector>
#include <iostream>
#include <initializer_list>

//////////////////////////////////////////////////////////////////////

class SomeInts {
private:
  typedef std::vector<int>::const_iterator iter_t;
public:
  SomeInts(std::initializer_list<double> list);  //!=b init list c'tor #2
  // implement simplest iterator
  iter_t begin() const { return cont_.begin(); }
  iter_t end() const { return cont_.end(); }
private:
  std::vector<int> cont_;
private:
  explicit SomeInts(); // no 
  SomeInts(const SomeInts&); // no 
  SomeInts& operator=(const SomeInts&); // no 
};

SomeInts::SomeInts(std::initializer_list<double> list)
  : cont_()
{
  for(auto it = list.begin(); it != list.end(); ++it)
    cont_.push_back( int {*it} ); //!=b unified initialization
}

//////////////////////////////////////////////////////////////////////

int main() {
  std::cerr << "=== " << __FILE__ << " ===" << std::endl;

  std::cerr << "The int-vector from double-list:";
  SomeInts vec2 { 1001.2, 2022.7, 3333.333 }; //!=b call init list c'tor #2
  for(auto it = vec2.begin(); it != vec2.end(); ++it) { //! auto typed variable
    std::cerr << "  " << *it;
  }
  std::cerr << std::endl;
    
  return EXIT_SUCCESS;
}

//- eof
