// resolving precedences.

#include <vector>
#include <iostream>
#include <initializer_list> //! include needed
#include <string>

//////////////////////////////////////////////////////////////////////

struct SomeInts {
  std::vector<int> cont_;
  SomeInts(std::initializer_list<int> list) : cont_() {
    cont_.assign(list.begin(), list.end());
  }
  SomeInts(std::initializer_list<long long>) : cont_() {
    cont_.assign({100000,1000001,10000002});
  }
  SomeInts(int a, int b, int c) : cont_(a) {
    cont_[b] = c;
  }
  int operator[](size_t i) const { return cont_[i]; }
};

struct SomeStrings {
  std::vector<std::string> cont_;
  SomeStrings(std::initializer_list<std::string> list) : cont_() {
    cont_.assign(list.begin(), list.end());
  }
  SomeStrings(const std::string &, const std::string &, const std::string &c) : cont_(10) {
    cont_[1] = c;
  }
  const std::string& operator[](size_t i) const { return cont_[i]; }
};
  
//////////////////////////////////////////////////////////////////////

int main() {
  std::cerr << "=== " << __FILE__ << " ===" << std::endl;
  
  std::cerr << "Sequence Constructor has precedence (10,1,42) and not (0,42,0):" << std::endl;
  SomeInts v { 10, 1, 42 }; //!=b call init list ctor
  std::cerr << v[0] << " " << v[1] << " " << v[2] << std::endl;

  std::cerr << "Usual Constructor will create (0,42,0):" << std::endl;
  SomeInts w ( 10, 1, 42 ); //!=b call normal ctor
  std::cerr << w[0] << " " << w[1] << " " << w[2] << std::endl;

#if 0
  std::cerr << "Narrowing in seq ctors is not allowed:" << std::endl;
  SomeInts x { 10.0, 1.0, 42.0 }; //!=b no narrowing allowed with seq ctors
  std::cerr << x[0] << " " << x[1] << " " << x[2] << std::endl;
#endif

  std::cerr << "Narrowing happens in std ctors (0,42,0):" << std::endl;
  SomeInts y ( 10.0, 1.0, 42.0 ); //!=b no narrowing allowed with seq ctors
  std::cerr << y[0] << " " << y[1] << " " << y[2] << std::endl;

  std::cerr << "char* to string is not narrowing ('abc','xyz','plop'):" << std::endl;
  SomeStrings s { "abc", "xyz", "plop" }; //!=b this is not narrowing
  std::cerr << s[0] << " " << s[1] << " " << s[2] << std::endl;

  std::cerr << "LongLong ('abc','xyz','plop'):" << std::endl;
  SomeInts z { 10LL, 20LL, 30LL }; //!=b this is not narrowing
  std::cerr << z[0] << " " << z[1] << " " << z[2] << std::endl;

  return EXIT_SUCCESS;
}

//- eof
