// rvalue references demo, how _never__ to do it
#include <vector>
#include <algorithm>  // generate_n
#include <iostream>   // cerr
#include "_numbers.hpp" // Number, Quadrate

class Faulting {
  int sz;
  Number* data;  // pointer member
public:
  explicit Faulting(int size) : sz(size), data()
  {
    data = new Number[sz];
    std::generate_n(data, sz, Quadrate());
  }
  ~Faulting() 
  { delete[] data; data=NULL;} // hopefully data is not shared //=b
};


int main() {
  std::cerr << "=== " << __FILE__ << " ===" << std::endl;

  Number::stats(std::cerr);
  {
    std::cerr << "  create object1..." << std::endl;
    Faulting ding1(100);
    Number::stats(std::cerr);

    std::cerr << "  make a copy of object1..." << std::endl;
    Faulting ding2(ding2);
    Number::stats(std::cerr);

    // ding2 will be destroyed here
    // ding1 will be destroyed here, and crash
  }
  Number::stats(std::cerr);
  
  return EXIT_SUCCESS;
}
//- eof
