// rvalue references demo, using auto_ptr os ok.
#include <vector>
#include <algorithm>  // generate_n
#include <iostream>   // cerr
#include <memory>     // auto_ptr //=b
#include "_numbers.hpp" // Number, Quadrate

class Teuer {
  int sz;
public:
  Number* data;  // pointer member
  explicit Teuer(int size) : sz(size), data()
  {
    data = new Number[sz];
    std::generate_n(data, sz, Quadrate());
  }
  ~Teuer() 
  { delete[] data; data=NULL;} // hopefully data is not shared
  Teuer(const Teuer& oth); // deep copy needed
  Teuer& operator=(const Teuer& oth); // deep assign needed 
};
typedef std::auto_ptr<Teuer> PTeuer; //= handle

Teuer::Teuer(const Teuer& oth) 
  : sz(oth.sz), data()
{
  data = new Number[sz]; // create new space //=b
  std::copy(data, data+sz, data); // deep copy //=b
}


PTeuer dingFactory(int decide) { // (2) shallow copy of pointer //=b
  PTeuer result(new Teuer(100));  // (1) create, wrap into auto_ptr //=b
  if(decide == 0)
    return result;
  else { // never reached, but prevent return-value-optimization
    std::cerr << "Tock!" << std::endl;
    PTeuer result2(new Teuer(999999999));
    result2->data[5] = result->data[6];
    return result2;
  }
}


int main() {
  std::cerr << "=== " << __FILE__ << " ===" << std::endl;
  int dec = -1;

  Number::stats(std::cerr);
  {
    std::cerr << "  create object1..." << std::endl;
    PTeuer ding1(new Teuer(100)); // the auto_ptr way //=b
    Number::stats(std::cerr);

    std::cerr << "  make a copy of object1..." << std::endl;
    PTeuer ding2(ding1);   // transferes ding1 to ding2 //=b
    Number::stats(std::cerr);

    dec = ding2->data[0]-1; // 0

    // ding2 will be destroyed here
    // ding1 has nothing to destroy //=b
  }
  Number::stats(std::cerr); // no leak in this version //=b
  
  {
    std::cerr << "  use makeDing() factory..." << std::endl;
    PTeuer ding3 = dingFactory(dec); // cheap factory //=b
  }
  Number::stats(std::cerr);

  return EXIT_SUCCESS;
}
//- eof
