
using namespace std;

struct Evil {
    char *data;
    Evil() { } // data not set!
    Evil(bool yesno) : Evil{} {
        if(yes) data = null;
        else throw runtime_error(); // crash!
    }
    ~Evil() {
        delete *data;
    }
};

struct OldBahaviour {
    char *data;
    OldBahaviour() { } // data not set!
    OldBahaviour(bool yesno) {  // no delegate here!
        if(yes) data = null;
        else throw runtime_error(); // ok!
    }
    ~OldBahaviour() {
        delete *data;
    }
}

int main() {
    {
        // totally fine, of course
        Evil ok(true);
    }
    {
        // dumping core:
        // - inner constr will complete, but *data still unititalized
        // - outer constr will throw
        // - destr will try to delet uninit'd data
        Evil ok(false);
    }
    {
        // fine, because no constr completes.
        OldBahaviour ok(false);
    }
}
