ct.log10 = function(x) {
	return Math.log(x) / Math.LN10;
}

ct.calcScale = function(range, pixels) {
	var magnitude = Math.floor(ct.log10(range.diff));
	var d = Math.pow(10, magnitude-1);
	range.min = range.min - range.min % d;
	range.max = range.max + d - range.min % d;
	range.diff = range.max - range.min;
	range.scale = pixels / range.diff;
	range.incr = d;
}

ct.makeRGBFromHue = function(H) {
	var h = H / 60;
	var C = Math.floor(0.9 * 256);
	var X = Math.floor(C * (1 - Math.abs(h % 2 - 1)));
	var RGB;
	if (h < 0)      RGB = [ 0, 0, 0 ];
	else if (h < 1)	RGB = [ C, X, 0 ];
	else if (h < 2)	RGB = [ X, C, 0 ];
	else if (h < 3)	RGB = [ 0, C, X ];
	else if (h < 4)	RGB = [ 0, X, C ];
	else if (h < 5)	RGB = [ X, 0, C ];
	else if (h < 6)	RGB = [ C, 0, X ];
	else            RGB = [ 0, 0, 0 ];
	return 'rgb(' + RGB.join(',') + ')';
}

// Konstruktor
ct.StarChart = function(map) {
	this.map = map;
	this.textColor = ct.StarChart.DefaultTextColor;
	this.textSize = ct.StarChart.DefaultTextSize;
	this.hairlineColor = ct.StarChart.DefaultHairlineColor;
	this.leftLabelWidth = ct.StarChart.DefaultLeftLabelWidth;
	this.bottomLabelHeight = ct.StarChart.DefaultBottomLabelHeight;
	this.topPadding = ct.StarChart.DefaultTopPadding;
	this.rightPadding = ct.StarChart.DefaultRightPadding;
	this.minHue = ct.StarChart.DefaultMinHue;
	this.maxHue = ct.StarChart.DefaultMaxHue;
	this.colors = [];
	this.colorCount = ct.StarChart.DefaultColorCount;
	this.highlightedStar = null;
	this.makeColorTable();
	this.range = new Array(4);
	this.svg = new ct.SVG();
	if (this.svg == null || !this.svg.supported()) {
		this.map.innerHTML = '<p style="font-weight: bold; color: red">Es sieht so aus, als ob Ihr Browser keine Scalable Vector Graphics (SVG) darstellen kann. Höchste Zeit, dass Sie Ihren Browser aktualisieren oder gegen einen besseren eintauschen.</p>';
		return null;
	}
	while (this.map.firstChild) // this.map leeren
		this.map.removeChild(this.map.firstChild);	
	this.map.appendChild(this.svg.element);
}

ct.StarChart.prototype.makeColorTable = function() {
	var Hd = (this.maxHue - this.minHue) / this.colorCount;
	for (var H = this.minHue; H < this.maxHue; H += Hd)
		this.colors.push(ct.makeRGBFromHue(H));
}

ct.StarChart.showInfoPopup = function(msg) {
}

ct.StarChart.hideInfoPopup = function(msg) {
}

ct.StarChart.highlightStar = function(x, y, r, A) {
	
}


ct.StarChart.DefaultTextColor = 'black';
ct.StarChart.DefaultTextSize = 11;
ct.StarChart.DefaultXScale = 20;
ct.StarChart.DefaultYScale = 20;
ct.StarChart.DefaultHairlineColor = 'rgb(240,240,240)';
ct.StarChart.DefaultStroke = 1.5;
ct.StarChart.DefaultMaxR = 20;
ct.StarChart.DefaultWidth = 640;
ct.StarChart.DefaultHeight = 480;
ct.StarChart.DefaultTopPadding = ct.StarChart.DefaultMaxR;
ct.StarChart.DefaultRightPadding = ct.StarChart.DefaultMaxR;
ct.StarChart.DefaultBottomLabelHeight = 40;
ct.StarChart.DefaultLeftLabelWidth = 50;
ct.StarChart.DefaultMinHue = 0;
ct.StarChart.DefaultMaxHue = 300;
ct.StarChart.DefaultColorCount = 200;


ct.StarChart.prototype.gradient = function(ratio) {
	return this.colors[Math.floor(ratio*(this.colors.length-1))];
}

ct.StarChart.prototype.star = function(x, y, r, A, row, parent) {
	var color = this.gradient(A);
	var label = this.data.getValue(row, 0) + ' hat bei ' + this.data.getValue(row, 2) + ' ' + this.unit_y + ' Produktionskosten ' + this.data.getValue(row, 3) + ' ' + this.unit_z + ' eingespielt';
	this.svg.star(x, y, r, {
		'fill': color,
		'fill-opacity': 0.8,
		'stroke-opacity': 0.8,
		'stroke-width': ct.StarChart.DefaultStroke,
		'stroke': color,
		'title': label,
		'onmouseover': 'ct.StarChart.highlightStar(' + x + ',' + y + ',' + r + ',' + A + ')',
		'onmouseout': 'ct.StarChart.hideInfoPopup(' + Math.floor(x) + ',' + Math.floor(y) + ',' + row + ')',
		'onclick': 'ct.StarChart.hideInfoPopup(' + row + ')',
	}, parent);
}

ct.StarChart.prototype.bar = function(x, y, w, h, v, parent) {
	this.svg.rect(x, y, w, h, {
		'fill': this.barColor,
		'stroke-width': ct.StarChart.DefaultStroke,
		'stroke': this.barBorderColor,
		'title': v
	}, parent);
}

ct.StarChart.prototype.rect = function(x, y, w, h, parent) {
	this.svg.rect(x, y, w, h, {
		'fill': 'transparent',
		'stroke-width': '1px',
		'stroke': 'black',
	}, parent);
}

ct.StarChart.prototype.hairline = function(x0, y0, x1, y1, parent) {
	this.svg.line(x0, y0, x1, y1, {
		'stroke-width': ct.StarChart.DefaultStroke,
		'stroke': this.hairlineColor
		}, parent);
}

ct.StarChart.prototype.vtext = function(x, y, text, opts, parent) {
	if (opts == null)
		opts = {};
	if (!opts['text-anchor'])
		opts['text-anchor'] = 'start';
	opts['transform'] = 'rotate(-90,' + x + ',' + y + ')';
	this.svg.text(x, y, this.textColor, text, opts, parent);	
}

ct.StarChart.prototype.htext = function(x, y, text, opts, parent) {
	this.svg.text(x, y, this.textColor, text, opts,	parent);	
}

ct.StarChart.prototype.draw = function(data, opts) {
	this.data = data;
	for (opt in opts)
		if (!this[opt])
			this[opt] = opts[opt]
	if (!this.width)
		this.width = ct.StarChart.DefaultWidth;
	if (!this.height)
		this.height = ct.StarChart.DefaultHeight;
	if (!this.maxR)
		this.maxR = ct.StarChart.DefaultMaxR;
	if (opts.rightPadding)
		this.rightPadding = opts.rightPadding;
	if (opts.topPadding)
		this.topPadding = opts.topPadding;
	this.innerWidth = this.width - this.leftLabelWidth - this.rightPadding;
	this.innerHeight = this.height - this.bottomLabelHeight - this.topPadding;
	for (var x = 1; x < this.data.getNumberOfColumns(); ++x) {
		var r = { min: Number.MAX_VALUE,
				  max: Number.MIN_VALUE,
			      diff: 0,
			      scale: 0,
			      incr: 1,
			      minSpace: this.textSize * 1.2 };
		for (var y = 0; y < this.data.getNumberOfRows(); ++y) {
			var v = this.data.getValue(y, x);
			if (v > r.max)
				r.max = v;
			if (v < r.min)
				r.min = v;
		}
		r.diff = r.max - r.min;
		this.range[x-1] = r;
	}
	ct.calcScale(this.range[0], this.innerWidth);
	ct.calcScale(this.range[1], this.innerHeight);
	this.range[2].scale = this.maxR / this.range[2].diff;
	this.range[3].scale = 1 / this.range[3].diff;
	
	// x-Achse zeichnen
	for (var i = 0; i < this.range[0].diff; i += this.range[0].incr) {
		var g = this.svg.group();
		this.vtext(this.textSize/2 + this.leftLabelWidth + i * this.range[0].scale, this.height, this.range[0].min + i, null, g);
		this.hairline(this.leftLabelWidth + i * this.range[0].scale, this.topPadding, this.leftLabelWidth + i * this.range[0].scale, this.innerHeight + this.topPadding, g);
	}
	if (opts.legend_x)
		this.htext(this.leftLabelWidth + this.innerWidth, this.topPadding + this.innerHeight + this.bottomLabelHeight, opts.legend_x);

	// y-Achse zeichnen
	for (var i = 0; i < this.range[1].diff; i += this.range[1].incr) {
		var g = this.svg.group();
		this.htext(this.leftLabelWidth-4, this.topPadding + this.textSize/2 + i * this.range[1].scale, this.range[1].min + i, { 'text-anchor': 'end' }, g);
		this.hairline(this.leftLabelWidth, this.topPadding + i * this.range[1].scale, this.leftLabelWidth + this.innerWidth, this.topPadding + i * this.range[1].scale, g);
	}
	if (opts.legend_y || opts.unit_y)
		var l = opts.legend_y? opts.legend_y:'';
		if (opts.unit_y)
			l += ' [' + opts.unit_y + ']';
		this.vtext(this.textSize, this.topPadding + this.innerHeight, l);
	
	
	for (var i = 0; i < this.data.getNumberOfRows(); ++i) {
		var x = this.data.getValue(i, 1) - this.range[0].min;
		var y = this.data.getValue(i, 2) - this.range[1].min;
		var v = this.data.getValue(i, 3) - this.range[2].min;
		var q = this.data.getValue(i, 4) - this.range[3].min;
		q = Math.round(q*100)/100;
		if (v > 0) {
			this.star(this.leftLabelWidth + x * this.range[0].scale, this.topPadding + y * this.range[1].scale, v * this.range[2].scale, q * this.range[3].scale, i);
		}
	}
	
	if (opts.colorLegend) {
		var g = this.svg.group();
		var h = this.innerHeight;
		var w = 1.2 * this.textSize;
		var x = this.leftLabelWidth + this.innerWidth + 14;
		var y = this.topPadding;
		var rh = 1;
		for (var i = 0; i < h; i += rh) {
			this.svg.line(x, y+h-i, x+w, y+h-i, {
				'stroke-width': rh,
				'stroke': this.gradient(i/h),
			}, g);
		}
		this.htext(x+w+4, y+this.textSize, Math.round(this.range[3].max*10)/10);
		this.htext(x+w+4, y+h, Math.round(this.range[3].min*10)/10);
		if (opts.legend_A)
			this.vtext(x+w+4+this.textSize, y+h/2, opts.legend_A, { 'text-anchor': 'middle'});
	}

	this.map.style.width = (this.width) + 'px';
	this.map.style.height = (this.height) + 'px'; 
	this.map.style.paddingLeft = '0px';
	this.map.style.paddingRight = '0px';
	this.map.style.paddingTop = '0px';
	this.map.style.paddingBottom = '0px';
}