﻿using System.IO.IsolatedStorage;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Xml.Serialization;
using Microsoft.Phone.Controls;


namespace PhoneRssReader
{
  public partial class EditFeeds : PhoneApplicationPage
  {
    public EditFeeds()
    {
      InitializeComponent();
    }

    protected override void OnNavigatedTo(System.Windows.Navigation.NavigationEventArgs e)
    {
      base.OnNavigatedTo(e);
      listBox1.ItemsSource = App.Feeds;
    }

    protected override void OnNavigatingFrom(System.Windows.Navigation.NavigatingCancelEventArgs e)
    {
      base.OnNavigatingFrom(e);
      //Save FeedList to IsolatedStorage
      using(IsolatedStorageFile isf = IsolatedStorageFile.GetUserStoreForApplication()) {
        using(IsolatedStorageFileStream fs = isf.CreateFile("Feeds.dat")) {
          // Serialize FeedList to file
          XmlSerializer ser = new XmlSerializer(typeof(FeedList));
          ser.Serialize(fs, listBox1.ItemsSource);
        }
      }
    }

    protected override void OnNavigatedFrom(System.Windows.Navigation.NavigationEventArgs e)
    {
      base.OnNavigatedFrom(e);
      listBox1.ItemsSource = null;
    }

    private void listBox1_SelectionChanged(object sender, SelectionChangedEventArgs e)
    {
      RssFeed feed = listBox1.SelectedItem as RssFeed;
      if(feed != null) {
        textURL.Text = feed.Url;
        btnDelete.IsEnabled = true;
      }
      else {
        textURL.Text = @"http://";
        btnDelete.IsEnabled = false;
      }
      btnAdd.IsEnabled = false;
      btnChange.IsEnabled = false;
    }

    private void textURL_TextChanged(object sender, TextChangedEventArgs e)
    {
      if(FocusManager.GetFocusedElement() == textURL) {
        bool isEmpty = string.IsNullOrEmpty(textURL.Text);
        btnAdd.IsEnabled = !isEmpty;
        btnChange.IsEnabled = !isEmpty && listBox1.SelectedItem != null;
      }
    }

    private void btnAdd_Click(object sender, RoutedEventArgs e)
    {
      if(!string.IsNullOrEmpty(textURL.Text)) {
        RssFeed feed = new RssFeed { Url = textURL.Text };
        App.Feeds.AddFeed(feed);
        listBox1.SelectedItem = feed;
      }
    }

    private void btnChange_Click(object sender, RoutedEventArgs e)
    {
      RssFeed feed = listBox1.SelectedItem as RssFeed;
      if(feed != null) {
        if(!string.IsNullOrEmpty(textURL.Text)) {
          feed.Url = textURL.Text;
          // feed.Title = "";
        }
      }
      btnAdd.IsEnabled = false;
      btnChange.IsEnabled = false;
    }

    private void btnDelete_Click(object sender, RoutedEventArgs e)
    {
      RssFeed feed = listBox1.SelectedItem as RssFeed;
      if(feed != null) {
        App.Feeds.RemoveFeed(feed);
      }
    }
  }
}