﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;


namespace PhoneRssReader
{
  public class FeedList : ObservableCollection<RssFeed>
  {
    public void AddFeed(RssFeed feed)
    {
      this.Add(feed);
      feed.DoneLoading += feed_DoneLoading;
    }

    public void RemoveFeed(RssFeed feed)
    {
      feed.DoneLoading -= feed_DoneLoading;
      this.Remove(feed);
    }

    void feed_DoneLoading(object sender, EventArgs e)
    {
      lock(this) {
        if(--feedsLoading == 0) {
          NotifyLoaded();
        }
      }
      needListBuild = true;
    }

    private int feedsLoading = 0;

    public void LoadAll()
    {
      if(feedsLoading != 0)
        throw new InvalidOperationException("Already loading.");

      lock(this) {
        feedsLoading = this.Count;
      }
      foreach(var feed in this) {
        feed.LoadFeed();
      }
    }

    public event EventHandler Loaded;
    private void NotifyLoaded()
    {
      if(Loaded != null)
        Loaded(this, EventArgs.Empty);
    }

    private bool needListBuild = true;

    [System.Xml.Serialization.XmlIgnoreAttribute]
    public List<RssItem> AllItems
    {
      get
      {
        if(needListBuild)
          BuildList();
        return itemList;
      }
    }

    private List<RssItem> itemList;

    private void BuildList()
    {
      itemList = new List<RssItem>();
      foreach(var feed in this) {
        itemList.AddRange(feed.Items);
      }
      itemList.Sort(new Comparison<RssItem>((i1, i2) => -i1.PublicationDate.CompareTo(i2.PublicationDate)));
      needListBuild = false;
    }
  }
}
