﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Threading;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Shell;
using Microsoft.Phone.Tasks;

namespace PhoneRssReader
{
  public partial class MainPage : PhoneApplicationPage
  {
    // Konstruktor
    public MainPage()
    {
      InitializeComponent();
      App.Feeds.Loaded += feeds_Loaded;
    }

    void feeds_Loaded(object sender, EventArgs e)
    {
      Dispatcher.BeginInvoke(DoneLoading);
    }

    private void DoneLoading()
    {
      listBox1.ItemsSource = App.Feeds.AllItems;
      UnWaitUI();
    }

    void WaitUI()
    {
      progressBar1.Visibility = System.Windows.Visibility.Visible;
      ((ApplicationBarIconButton)ApplicationBar.Buttons[0]).IsEnabled = false;
      // ((ApplicationBarMenuItem)ApplicationBar.MenuItems[0]).IsEnabled = false;
    }

    void UnWaitUI()
    {
      // ((ApplicationBarMenuItem)ApplicationBar.MenuItems[0]).IsEnabled = true;
      ((ApplicationBarIconButton)ApplicationBar.Buttons[0]).IsEnabled = true;
      progressBar1.Visibility = System.Windows.Visibility.Collapsed;
    }

    private void reload_Click(object sender, EventArgs e)
    {
      WaitUI();
      listBox1.ItemsSource = null;
      App.Feeds.LoadAll();
    }

    private void edit_Click(object sender, EventArgs e)
    {
      NavigationService.Navigate(new Uri("/EditFeeds.xaml", UriKind.Relative));
    }

    protected override void OnNavigatedTo(System.Windows.Navigation.NavigationEventArgs e)
    {
      base.OnNavigatedTo(e);
      Dispatcher.BeginInvoke(() => reload_Click(this, EventArgs.Empty));
    }

    private void btnGoto_Click(object sender, RoutedEventArgs e)
    {
      Button b = sender as Button;
      if(b != null) {
        RssItem item = b.DataContext as RssItem;
        if(item != null) {
          WebBrowserTask browser = new WebBrowserTask();
          browser.URL = item.Url;
          browser.Show();
        }
      }
    }
  }
}