﻿// 4 Abkürzungen für oft benötigte DOM-Funktionen:
// findet ein Element:
function $(str, nr) {return document.getElementsByTagName(str)[nr];}
function $_(str) {return document.getElementById(str);}
// erzeugt ein Element:
function c(str) {return document.createElement(str);}
// erzeugt einen Textknoten:
function txt(str) {return document.createTextNode(str);}

var abschnitt, neueintrag, button, startnachricht, aufgeraeumt, storage, d, eingabe, autor, autor_db, offlinemodus; // später benötigte Variablen
// Wochentage und Kalendermonate für Datumsausgabe:
var Wochentage = new Array('Sonntag', 'Montag', 'Dienstag', 'Mittwoch', 'Donnerstag', 'Freitag', 'Samstag');
var Monate = new Array('Januar', 'Februar', 'März', 'April', 'Mai', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember');
// Nach dem Laden des Dokuments geht's mit init() los
window.onload = init;

function init() { // startet nach dem Laden des HTML-Dokuments
 // prüft den Online-Status (unzuverlässig in Browsern implementiert):
 debug('Online-Status: ' + navigator.onLine);
 // schreibt Appcache-Status in die Debug-Konsole:
 cachestatus();
 // liest einige HTML-Elemente ein:
 abschnitt = $('section', 0);
 neueintrag = $('textarea', 0);
 button = $('input', 0);
 startnachricht = neueintrag.value; // speichert den Text "Schreib hier!"
 neueintrag.onclick = aufraeumen; // ... der beim Anklicken ...
 neueintrag.onfocus = aufraeumen; // ... und beim Fokussieren gelöscht wird
 button.onclick = speichern; // löst die Speicherfunktion aus
 // Prüft, ob Speicherung möglich ist (-> storage = true):
 if (typeof(localStorage) == 'undefined' || typeof(localStorage) == 'unknown') {
  debug('kein localStorage');
 } else {
  storage = true;
  lesen(); // liest die Datenbankeinträge aus
  sync(); // synchronisiert die Daten
 }
}

function aufraeumen() { // nach Anklicken oder Fokussieren des Eingabefelds
 // Der (Standard-)Text soll nur gelöscht werden, wenn nicht "aufgeraeumt" ist:
 if (aufgeraeumt) return;
 neueintrag.value = '';
 aufgeraeumt = true;
}

function speichern() { // nach Anklicken des Speicher-Buttons
 if (!storage) return; // Abbruch, wenn Speichern nicht möglich ist
 eingabe = neueintrag.value; // eingegebener Text
 if (eingabe == '' || eingabe == startnachricht) return; // es muss etwas drinstehen
 var datum = new Date();
 d = datum.getTime(); // Datum als Zahl (Millisekunden seit 1.1.1970)
 autor = $('h2', 0).firstChild.nodeValue; // Inhalt der <h2>
 autor_db = localStorage.getItem('autor'); // Datenbankeintrag "autor"
 if (navigator.geolocation) { // ist Ortung möglich?
  // versuche zu orten. Wenn es klappt: adresse_ermitteln(), sonst adresse_fehler(); Abbruch nach 1,5 Sekunden:
  navigator.geolocation.getCurrentPosition(adresse_ermitteln, adresse_fehler, {timeout:1500});
 } else { // wenn Ortung nicht möglich ist, speichere sofort:
  daten_schreiben();
 }
}

function daten_schreiben() { // beendet den Speichervorgang: speichern() leitet direkt oder über den Umweg adresse_ermitteln() hierher
 try { // fängt eventuelle Fehler ab
  // speichere den <h2>-Inhalt, wenn er sich geändert hat:
  if (autor != autor_db) localStorage.setItem('autor', autor);
  localStorage.setItem(d, eingabe); // speichert den eingegebenen Text
  debug('Eintrag lokal gespeichert');
  neueintrag.value = startnachricht; // setzt den <textarea>-Inhalt zurück
  aufgeraeumt = false; // stellt den Ausgangszustand wieder her
  ajax_verbinden('speichern', d, eingabe); // übergibt die Daten der Ajax-Funktion zur serverseitigen Speicherung
 } catch (e) { // wenn Fehler aufgetreten sind:
  debug('Fehler beim Speichern: ' + e);
 }
 lesen(); // lies die aktualisierte Datenbank aus
}

function lesen() { // beim Start, nach dem Speichern oder Löschen ausgelöst
 // lösche eine vom letzten lesen() eventuell vorhandene <ol>:
 if ($('ol', 0)) abschnitt.removeChild($('ol', 0));
 if (!storage) return;
 // sucht in der Datenbank nach "autor". Gibt es einen Eintrag, ersetze damit den Inhalt von <h2>:
 if (autor = localStorage.getItem('autor')) $('h2', 0).firstChild.nodeValue = autor;
 var ol = c('ol'); // erzeuge eine neue <ol>
 // lies die Schlüssel der Datenbank in das Array keys ein:
 var keys = Array();
 for (var i = 0; i < localStorage.length; i++) keys.push(localStorage.key(i));
 keys = keys.sort(); // sortiert die Schlüssel
 // durchläuft die Schlüssel (in umgekehrter Reihenfolge):
 for (var i = keys.length; i-- > 0;) {
  // Lies den Datenbankeintrag in schluessel und wert ein:
  var schluessel = keys[i];
  var wert;
  // wenn wert leer ist, geh zum nächsten Eintrag:
  if (!(wert = localStorage.getItem(schluessel))) continue;
  // trennt den Datenbankeintrag an ":ORT:" auf; hier steht das Ergebnis der Ortung:
  var tmp = wert.split(':ORT:', 2);
  wert = tmp[0]; // Eingabetext
  var ort = tmp[1]; // Ortung (falls vorhanden)
  schluessel = parseInt(schluessel);
  if (isNaN(schluessel)) continue; // schluessel muss ein Datum im Zahlenformat sein
  /*
  erzeuge folgende Struktur:
  <li>
    <div id="schluessel">
      <h3>Datum<br/>Ort</h3>
      <p>Eintrag</p>
    </div>
  </li>
  */
  var li = c('li');
  var div = c('div');
  var h3 = c('h3');
  var p = c('p');
  // mach aus dem Datum im Zahlenformat ein menschenlesbares:
  var dat = new Date(schluessel);
  var dat_wochentag = Wochentage[dat.getDay()];
  var dat_kalendertag = dat.getDate();
  var dat_monat = dat.getMonth();
  var dat_jahr = dat.getFullYear();
  var dat_stunde = dat.getHours();
  var dat_minute = dat.getMinutes();
  if (dat_minute < 10) dat_minute = '0' + dat_minute;
  var aenderungsdatum = dat_wochentag + ', ' + dat_kalendertag + '. ' + Monate[dat_monat] + ' ' + dat_jahr + ' um ' + dat_stunde + ':' + dat_minute;
  // beim ersten Durchlauf passen wir auch das Datum im <footer> an:
  if (!letzte_aenderung) {
   var letzte_aenderung = aenderungsdatum;
   if (++dat_monat < 10) dat_monat = '0' + dat_monat;
   if (dat_kalendertag < 10) dat_kalendertag = '0' + dat_kalendertag;
   if (dat_stunde < 10) dat_stunde = '0' + dat_stunde;
   var letzte_aenderung_pd = dat_jahr + '-' + dat_monat + '-' + dat_kalendertag + 'T' + dat_stunde + ':' + dat_minute;
   // aktualisiere den Inhalt von <time> und das datetime-Attribut:
   var time = $('time', 0);
   time.firstChild.nodeValue = letzte_aenderung;
   time.setAttribute('datetime', letzte_aenderung_pd);
  }
  // bau die erzeugten HTML-Elemente und die Inhalte in die Seite ein:
  h3.appendChild(txt(aenderungsdatum));
  if (ort) {
   h3.appendChild(c('br'));
   h3.appendChild(txt('in ' + ort));
  }
  p.appendChild(txt(wert));
  div.appendChild(h3);
  div.appendChild(p);
  div.setAttribute('id', schluessel);
  li.appendChild(div);
  ol.appendChild(li);
 }
 // füg die <ol>-Liste (wenn sie einen Inhalt hat) ans Ende von <section> ein:
 if (li) abschnitt.appendChild(ol);
 // verbinde jeden Listeneintrag über den Doppelklick mit der Funktion loeschen():
 var eintraege = ol.getElementsByTagName('div');
 for (var i = 0; i < eintraege.length; i++) eintraege[i].ondblclick = loeschen;
}

function loeschen() { // nach Doppelklick auf einen Eintrag
 if (!storage) return;
 // zeig zur Sicherheit einen Bestätigungsdialog:
 var frage = confirm("Wollen Sie diesen Eintrag wirklich löschen?");
 if (frage) {
  localStorage.setItem(this.id, ''); // der Inhalt von <div id="..."> ist der Datenbankschlüssel
  debug('Eintrag lokal gelöscht');
  ajax_verbinden('loeschen', this.id, null); // übergibt die Daten der Ajax-Funktion zum serverseitigen Löschen
  lesen(); // lies die aktualisierte Datenbank neu ein
 }
}

function adresse_ermitteln(pos) { // Callback-Funktion, beim speichern() ausgelöst
 var geo = new google.maps.Geocoder(); // Geocoder-Objekt aus dem Google-Maps-API
 var coords = new google.maps.LatLng(pos.coords.latitude, pos.coords.longitude);
 // übergib die Koordinaten an das Google-Maps-API:
 geo.geocode({'latLng': coords}, function(results, status) {
  var adresse = (status == google.maps.GeocoderStatus.OK)? results[0].formatted_address : 'Adresse nicht ermittelt: ' + status; // adresse enthält entweder eine formatierte Straßenadresse oder einen Fehlerhinweis
  eingabe += ':ORT:' + adresse; // hängt die Adresse an den Eingabetext, getrennt durch ":ORT:"
  daten_schreiben(); // schreibt die Daten in die Datenbank
 });
 debug('Adresse aufgelöst');
}

function adresse_fehler(err) { // Geolocation ist bei der Ortung gescheitert
 eingabe += ':ORT:Probleme bei der Ortung';
 // err.message sollte einen Fehlertext enthalten, das klappt in der Praxis jedoch nicht immer. Zuverlässiger ist err.code:
 switch(err.code) {
  case 1 : debug('Ortung: keine Erlaubnis'); break;
  case 2 : debug('Ortung: Server konnte nicht orten'); break;
  case 3 : debug('Ortung: Timeout'); break;
  default : debug('Ortung: keine Angabe'); break;
 }
 daten_schreiben(); // schreibt die Daten in die Datenbank
}

function cachestatus() { // gibt Debug-Informationen über den Appcache
 var ac;
 if (!(ac = window.applicationCache)) return;
 ac.addEventListener('checking', function() {debug('Prüfe den Cache ...');}, false); // bei jedem Laden
 ac.addEventListener('noupdate', function() {debug('Kein Cache-Update nötig');}, false); // keine neue .manifest-Datei
 ac.addEventListener('downloading', function() {debug('Aktualisiere den Cache ...');}, false); // neue .manifest-Datei
 ac.addEventListener('progress', function() {debug('Lade Datei herunter ...');}, false); // wird bei jeder zu cachenden Datei ausgelöst
 ac.addEventListener('updateready', function() {debug('Cache-Update bereit ...');}, false);
 ac.addEventListener('cached', function() {debug('Cache ist aktuell');}, false);
 ac.addEventListener('obsolete', function() {debug('Cache ist obsolet');}, false);
 ac.addEventListener('error', function() {debug('Problem mit Cache');}, false);
}

function ajax_verbinden(aktion, id, eingabe) { // spricht per Ajax ein serverseitiges PHP-Skript an
 try {
  var ajax = new XMLHttpRequest(); // erzeugt in allen aktuellen Browsern ein Ajax-Objekt
 } catch(e) {
  debug('kein Ajax möglich: ' + e);
  return;
 }
 var senden = 'aktion=' + aktion + '&id=' + id + '&eintrag=' + eingabe; // wird per POST übergeben
 ajax.open('POST', 'html5app_speichern.php', true); // öffnet die Verbindung
 // setze Header für MIME-Typ, Kodierung und Größe der POST-Daten und beende Verbindung nach Antwort:
 ajax.setRequestHeader("Content-type", "application/x-www-form-urlencoded; charset=iso-8859-1");
 ajax.setRequestHeader("Content-length", senden.length);
 ajax.setRequestHeader("Connection", "close");
 debug('Ajax: ' + aktion + ' von ' + id);
 ajax.send(senden); // schickt den Request ab
 // definiere eine Timer, der nach 2,5 Sekunden den Verbindungsversuch abbricht:
 var timer = window.setTimeout(function() {
  ajax.abort();
  offlinemodus = true; // wechselt in den Offline-Modus
  debug('Timeout: Offline-Modus');
 }, 2500);
 ajax.onreadystatechange = function() {
  if (ajax.readyState == 4) { // die Antwort des Servers liegt vor
   window.clearTimeout(timer); // löscht den Timeout
   if (ajax.status == 200) { // HTTP-Status 200: Verbindung war okay
    debug('Server-Antwort: ' + ajax.responseText);
    // wenn das Skript vorher im Offline-Modus war: beende ihn und synchronisiere:
    if (offlinemodus) {
     offlinemodus = false;
     sync();
    }
   } else {
    // das Server-Skript war nicht erreichbar:
    debug('Ajax-Dokument nicht erreichbar: HTTP-Status ' + ajax.status);
   }
  }
 }
}

function sync() { // synchronisiert die lokale und die Server-Datenbank
 if (offlinemodus) return; // ... aber nur, wenn wir nicht offline sind
 debug('Synchronisiere ...');
 try {
  var ajax = new XMLHttpRequest(); // erzeugt in allen aktuellen Browsern ein Ajax-Objekt
 } catch(e) {
  debug('kein Ajax möglich: ' + e);
 }
 ajax.open('GET', 'html5app_speichern.php', true); // öffnet die Verbindung
 ajax.send(null); // bei HTTP-GET werden keine Daten gesendet
 ajax.onreadystatechange = function() {
  if (ajax.readyState == 4) { // die Antwort des Servers liegt vor
   if (ajax.status == 200) { // HTTP-Status 200: Verbindung war okay
    // das PHP-Skript sollte den Inhalt der Datenbank im JSON-Format geschickt haben:
    debug('Lese Online-Datenbank ein ...');
    try {
     var onlinedb = JSON.parse(ajax.responseText); // onlinedb enthält die komplette Online-Datenbank als Array
    } catch(e) {
     // brich ab, wenn das Einlesen gescheitert ist:
     debug('JSON-Daten nicht lesbar: ' + e);
     offlinemodus = true;
     return;
    }
    // schreib alle Schlüssel der lokalen Datenbank in das Objekt keys. keys ist ein Pseudo-Hash, damit sich die Einträge leichter finden lassen als in einem Array (keys[schluessel] = true):
    var keys = new Object;
    for (var i = 0; i < localStorage.length; i++) {
     var key = localStorage.key(i);
     keys[key] = true;
    }
    while (onlinedb.length) { // geht alle Einträge der Online-Datenbank durch
     var onlineItem = onlinedb.shift(); // schnappt sich den jeweils ersten
     var offlineWert;
     // Fall 1 - Eintrag liegt online und offline vor:
     if (offlineWert = localStorage.getItem(onlineItem.id)) {
      // 1a - online zum Löschen markiert -> offline löschen:
      if (onlineItem.eintrag == '') {
       localStorage.removeItem(onlineItem.id);
       debug('Eintrag ' + onlineItem.id + ' lokal gelöscht');
      // 1b - offline zum Löschen markiert -> online markieren:
      } else if (offlineWert == '') {
       ajax_verbinden('loeschen', this.id, null);
       localStorage.removeItem(onlineItem.id);
       debug('Eintrag ' + onlineItem.id + ' online gelöscht');
      }
      // entferne den Eintrag aus keys:
      delete keys[onlineItem.id];
     // Fall 2 - der Eintrag liegt nur online vor:
     } else {
      // wenn es einen Inhalt gibt, speichere ihn lokal:
      if (onlineItem.eintrag) {
       localStorage.setItem(onlineItem.id, onlineItem.eintrag);
       debug('Online-Eintrag ' + onlineItem.id + ' synchronisiert');
      }
      // wenn nicht, war es online zum Löschen markiert -> tu nichts
     }
    }
    // keys enthält nur noch Einträge, die online nicht vorliegen:
    for (var i in keys) {
     // Fall 1 - lokaler Eintrag ist leer -> löschen:
     if (localStorage.getItem(i) == '') {
      localStorage.removeItem(i);
     // Fall 2 - lade ihn hoch, wenn der Schlüssel eine Zahl ist:
     } else {
      if (isNaN(parseInt(i))) continue;
      ajax_verbinden('speichern', i, localStorage.getItem(i));
     }
    }
    debug('Synchronisieren abgeschlossen');
    lesen(); // liest die lokale Datenbank neu ein
   } else { // HTTP-Statuscode war nicht 200 = ok:
    offlinemodus = true;
    debug('Ajax-Dokument nicht erreichbar');
    return;
   }
  }
 }
}

function debug(text) { // gibt Debug-Informationen aus
 // wenn es keinen Container mit der id="debug" gibt, erzeuge ihn:
 if (!$_('debug')) {
  var div = c('div');
  div.setAttribute('id', 'debug');
  document.body.appendChild(div);
 }
 // schreib die übergebene Nachricht in den Debug-Container:
 var p = c('p');
 var text = txt(text);
 p.appendChild(text);
 $_('debug').appendChild(p);
}