#!/bin/sh

VM=winxp
HD=winxp-hda.vdi

# Virtuelle Maschine erstellen
VBoxManage --nologo createvm --name $VM --ostype WindowsXP --register
# Eigenschaften der VM anpassen
VBoxManage --nologo modifyvm $VM --memory 2000 --vram 128 --boot1 dvd --boot2 disk --boot3 none --boot4 none --audio alsa --audiocontroller ac97 --usb on --usbehci on
# Gemeinsame Ordner einrichten
VBoxManage --nologo sharedfolder add $VM --name home --hostpath /home/keinpasswort
VBoxManage --nologo sharedfolder add $VM --name media --hostpath /media
# Festplatten-Image erstellen
VBoxManage --nologo createhd --filename $HD --size 50000 --remember
# "ide" Controller hinzufügen ("sata" ist bei WinXP umständlich)
VBoxManage --nologo storagectl $VM --name 'IDE Controller' --add ide --controller PIIX3
# Festplatte am ersten Bus "0" als Master "0" einhängen
VBoxManage --nologo storageattach $VM --storagectl 'IDE Controller' --port 0 --device 0 --type hdd --medium $HD
