#!/bin/sh
# 
# Wrapper-Script for dnsmasq Scriptoption
# Reiko Kaps <rek@ct.de> 2010

ARG=$1
MAC=$2
IP=$3
NAME=$4
RUNDIR_ADD="/etc/dhcp/add.d/"
RUNDIR_DEL="/etc/dhcp/del.d/"

errorandexit()
{
 	logger -p daemon.info -t dnsmasq-dhcp  "$0: Something went wrong, quitiing execution!"
 	exit 1
}

rundir()
{	
	[ ! -d $1 ] && return	
	[ -f $1/default.sh ] && . $1/default.sh
	[ -f $1/$MAC ] && {
		logger -p daemon.info -t dnsmasq-dhcp "Running script $1/$MAC"
		. $1/$MAC
	}
}
	
case "$ARG" in
	add|old)
	logger -p daemon.info -t dnsmasq-dhcp "$ARG Client ($MAC/$IP, $NAME)" 
	rundir $RUNDIR_ADD
	;;
	del)
	logger -p daemon.info -t dnsmasq-dhcp "$ARG Client ($MAC/$IP, $NAME)"
	rundir $RUNDIR_DEL
	;;
	*)
	errorandexit
	;;
esac
exit 0
