﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;

namespace FireBirds
{
    public class ScrollingBackground
    {
        //Variable für unsere Grafik
        public Texture2D texBackground;

        //X,Y, Textur Breite und Höhe
        public Rectangle recBackgroundPositionAndDimension;

        //X,Y, Textur Breite und Höhe
        public Rectangle recBackgroundPositionAndDimension1;

        GraphicsDevice graphics;

        public void LoadContent(ContentManager Content, GraphicsDevice graphics)
        {
            //Die Konvertierte XNB Datei wird in texBackground geladen
            texBackground = Content.Load<Texture2D>("Graphics\\ground");
            
            //Den ersten Hintergrund platzieren wir genau in unsererm Fenster
            recBackgroundPositionAndDimension.X = 0;
            recBackgroundPositionAndDimension.Y = 0;
            recBackgroundPositionAndDimension.Width     = graphics.Viewport.Width;
            recBackgroundPositionAndDimension.Height    = graphics.Viewport.Height;

            //Den zweiten verschieben wir in der Y Achse genau eine Textur Höhe nach oben
            recBackgroundPositionAndDimension1.X = 0;
            recBackgroundPositionAndDimension1.Y = -graphics.Viewport.Height;
            recBackgroundPositionAndDimension1.Width = graphics.Viewport.Width;
            recBackgroundPositionAndDimension1.Height = graphics.Viewport.Height;

            //In dieser Variable ist die Grösse von unsererm Fenster gespeichert
            //die wir im Anschluss brauchen um die Hintergründe wieder nach oben zu setzen
            this.graphics = graphics;
        }

        public void Update()
        {
            //Wir bewegen die einzelnen Hintergründe in jedem durchgang 2 nach unten
            recBackgroundPositionAndDimension.Y  += 2;
            recBackgroundPositionAndDimension1.Y += 2;

            //Berührt die erste Textur mit seiner Oberkannte die Unterkante des Fenster,
            //weisen wir dem Hintergrund eine neue Position auf der Y Achse zu
            if(recBackgroundPositionAndDimension.Y >= graphics.Viewport.Height)
              recBackgroundPositionAndDimension.Y = recBackgroundPositionAndDimension1.Y - graphics.Viewport.Height;

           //Dasselbe für den 2-ten Hintergrund
            if(recBackgroundPositionAndDimension1.Y >= graphics.Viewport.Height)
              recBackgroundPositionAndDimension1.Y = recBackgroundPositionAndDimension.Y - graphics.Viewport.Height;
        }

        public void Draw(SpriteBatch spriteBatch)
        {
            spriteBatch.Draw(texBackground, recBackgroundPositionAndDimension, Color.White);
            spriteBatch.Draw(texBackground, recBackgroundPositionAndDimension1, Color.White);
        }
    }
}
