// Copyright (c) 2011 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: 3dwidget.h 56a02adc47db 2011/09/02 13:36:19 Oliver Lau <oliver@von-und-fuer-lau.de> $

#ifndef __3DWIDGET_H_
#define __3DWIDGET_H_

#include <QObject>
#include <QString>
#include <QSize>
#include <QPoint>
#include <QMouseEvent>
#include <QWheelEvent>
#include <QKeyEvent>
#include <QCloseEvent>
#include <QGLWidget>
#include <QTimerEvent>
#include <QThread>
#include <QVector>

#include <MSR_NuiApi.h>

#include "nui.h"

//#ifndef GL_MULTISAMPLE
//#define GL_MULTISAMPLE  0x809D
//#endif

class ThreeDWidget : public QGLWidget
{
    Q_OBJECT
public: // methods
    explicit ThreeDWidget(QWidget* parent = NULL);
    ~ThreeDWidget(void);
    QSize minimumSizeHint(void) const { return QSize(320, 240); }
    QSize sizeHint(void) const { return QSize(1920, 1280); }
    void setXRotation(int);
    void setYRotation(int);
    void showHotspot(bool enabled = true);
    void displayMessage(QString msg = QString(), int timeout = -1);

public slots:
    void setSkeletons(const SkeletonList&);
    void clearMessage(void);

private: // variables
    int mXRot;
    int mYRot;
    float mXTrans;
    float mYTrans;
    float mZTrans;
    float mZoom;
    GLuint mRoom;
    GLuint mBody;
    GLuint mKinect;
    int mLastFloorLevel; // cm
    int mLastTilt;
    QPoint mLastPos;
    QImage mTextureImg;
    GLuint* mTextureHandle;
    bool mHotspotEnabled;
    QString mMessage;
    GLuint mHotspot;
    int mHotspotTimer;
    float mHotspotRotation;
    static const int NumHandles = 1;
    static const float DefaultZoom;
    static const float light0_diffuse[];
    static const float light0_pos[];
    static const float mat_shininess[];
    static const float mat_specular[];

private: // methods
    void loadTexture(const QString& name, GLuint handle);
    void makeRoom(void);
    void makeKinect(void);
    void makeHotspot(void);

protected: // methods
    void initializeGL(void);
    void resizeGL(int, int);
    void paintGL(void);
    void mousePressEvent(QMouseEvent*);
    void mouseReleaseEvent(QMouseEvent*);
    void mouseMoveEvent(QMouseEvent*);
    void wheelEvent(QWheelEvent*);
    void keyPressEvent(QKeyEvent*);
    void timerEvent(QTimerEvent*);

};

#endif // __3DWIDGET_H_
