// Copyright (c) 2011 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: posehelperwidget.h 865377b019de 2011/08/16 14:43:19 Oliver Lau <oliver@von-und-fuer-lau.de> $

#ifndef __POSEHELPERWIDGET_H_
#define __POSEHELPERWIDGET_H_

#include <QWidget>

#include "flagsemaphore.h"


class PoseHelperWidget : public QWidget
{
    Q_OBJECT
public:
    explicit PoseHelperWidget(QWidget* parent = NULL);

    QSize minimumSizeHint(void) const { return QSize(320, 240); }
    QSize sizeHint(void) const { return QSize(320, 240); }

    void setPose(const FlagSemaphore::Position&, bool, float opacity = 1.0f);

protected:
    void paintEvent(QPaintEvent*);

private:
    FlagSemaphore::Position mPose;
    bool mShowPose;
    float mOpacity;
};

#endif // __POSEHELPERWIDGET_H_
