// Copyright (c) 2011 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: speechrecognizer.h c5f95eadb0c7 2011/11/03 10:12:40 Oliver Lau <oliver@von-und-fuer-lau.de> $

#ifndef __SPEECHRECOGNIZER_H_
#define __SPEECHRECOGNIZER_H_

#include <QObject>
#include <QString>
#include <QThread>

#include <Windows.h>
#include <atlbase.h>

#pragma warning(disable: 4805)
#include <sphelper.h>
#pragma warning(default: 4805)

class SpeechRecognizer : public QObject
{
    Q_OBJECT
public:
    explicit SpeechRecognizer(QObject* parent = NULL);
    ~SpeechRecognizer();

signals:
    void phraseRecognized(QString word, QString ruleName, float confidence);

private:
    static void __stdcall sapiCallback(WPARAM, LPARAM);
    void sapiEventReceived(void);
    CComPtr<ISpRecoContext> mRecognitionCtx;
    CComPtr<ISpRecoGrammar> mDictationGrammar;
};

#endif // __SPEECHRECOGNIZER_H_
