// Copyright (c) 2011 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: flagsemaphore.cpp f9a43276afac 2011/11/03 10:35:31 Oliver Lau <oliver@von-und-fuer-lau.de> $

#include "flagsemaphore.h"
#include <QObject>

namespace FlagSemaphore {

    FlagSemaphore* FlagSemaphore::mInstance = NULL;


    SemaphoreMap FlagSemaphore::mPositions;


    FlagSemaphore* FlagSemaphore::instance(void)
    {
        if (mInstance == NULL)
            mInstance = new FlagSemaphore;
        return mInstance;
    }


    FlagSemaphore::FlagSemaphore()
    {
        mPositions[QObject::tr("Rest/Space")] = Position(DOWN, DOWN);
        mPositions[QObject::tr("Numerals")] = Position(UP, SIDE_UP);
        mPositions["A/1"] = Position(SIDE_DOWN, DOWN);
        mPositions["B/2"] = Position(SIDE, DOWN);
        mPositions[QObject::tr("C/3/ACK")] = Position(SIDE_UP, DOWN);
        mPositions["D/4"] = Position(UP, DOWN);
        mPositions[QObject::tr("E/5/8x/Error")] = Position(DOWN, SIDE_UP);
        mPositions["F/6"] = Position(DOWN, SIDE);
        mPositions["G/7"] = Position(DOWN, SIDE_DOWN);
        mPositions["H/8"] = Position(SIDE, OTHER | SIDE_DOWN);
        mPositions["I/9"] = Position(SIDE_DOWN, OTHER | SIDE_UP);
        mPositions[QObject::tr("J/Letters")] = Position(UP, SIDE);
        mPositions["K/0"] = Position(SIDE_DOWN, UP);
        mPositions["L"] = Position(SIDE_DOWN, SIDE_UP);
        mPositions["M"] = Position(SIDE_DOWN, SIDE);
        mPositions["N"] = Position(SIDE_DOWN, SIDE_DOWN);
        mPositions["O"] = Position(SIDE, OTHER | SIDE_UP);
        mPositions["P"] = Position(SIDE, UP);
        mPositions["Q"] = Position(SIDE, SIDE_UP);
        mPositions["R"] = Position(SIDE, SIDE);
        mPositions["S"] = Position(SIDE, SIDE_DOWN);
        mPositions["T"] = Position(SIDE_UP, UP);
        mPositions["U"] = Position(SIDE_UP, SIDE_UP);
        mPositions["V"] = Position(UP, SIDE_DOWN);
        mPositions["W"] = Position(OTHER | SIDE_UP, SIDE);
        mPositions["X"] = Position(OTHER | SIDE_UP, SIDE_DOWN);
        mPositions["Y"] = Position(SIDE_UP, SIDE);
        mPositions["Z"] = Position(OTHER | SIDE_DOWN, SIDE);
    }

}
