// Copyright (c) 2011 Oliver Lau <oliver@von-und-fuer-lau.de>
// Alle Rechte vorbehalten.
// $Id: helper.h cf169bb4ae86 2011/10/06 17:09:09 Oliver Lau <oliver@von-und-fuer-lau.de> $

#ifndef __HELPER_H_
#define __HELPER_H_

#include <qmath.h>

#ifndef __IN
#define __IN
#endif
#ifndef __OUT
#define __OUT
#endif

/// Gradma in Bogenma umwandeln.
/// @param rad Gradma
/// @return Bogenma
template <typename REAL>
inline REAL deg2rad(REAL deg)
{
    return deg * M_PI / 180;
}


/// Bogenma in Gradma umwandeln.
/// @param rad Bogenma
/// @return Gradma
template <typename REAL>
inline REAL rad2deg(REAL rad)
{
    return rad / M_PI * 180;
}


#endif // __HELPER_H_
