// Copyright (c) 2011 Oliver Lau <oliver@von-und-fuer-lau.de>
// Alle Rechte vorbehalten.
// $Id: line.h cf169bb4ae86 2011/10/06 17:09:09 Oliver Lau <oliver@von-und-fuer-lau.de> $

#ifndef __LINE_H_
#define __LINE_H_

#include "helper.h"
#include "point.h"

/// Die Klasse Line reprsentiert eine Verbindungslinie zwischen zwei Punkten
/// in einem zwei- oder dreidimensionalen Koordinatensystem.
class Line {
public:
    /// Konstruktor.
    Line(void) { /* ... */ }

    /// Konstruktor.
    /// @param p1 Erster Punkt.
    /// @param p2 Zweiter Punkt.
    Line::Line(const Point& p1, const Point& p2)
        : mP1(p1), mP2(p2)
    { /* ... */ }

    /// Konstruktor.
    Line::Line(float x1, float y1, float x2, float y2)
        : mP1(x1, y1), mP2(x2, y2)
    { /* ... */ }

    /// Konstruktor.
    Line::Line(float x1, float y1, float z1, float x2, float y2, float z2)
        : mP1(x1, y1, z1), mP2(x2, y2, z2)
    { /* ... */ }

    /// Ersten Punkt zurckgeben.
    /// @return Erster Punkt
    inline const Point& p1(void) const { return mP1; }

    /// Zweiten Punkt zurckgeben.
    /// @return Zweiter Punkt
    inline const Point& p2(void) const { return mP2; }

    /// Ersten Punkt setzen.
    /// @param p1 Erster Punkt.
    inline void setP1(const Point& p1) { mP1 = p1; }

    /// Zweiten Punkt setzen.
    /// @param p1 Zweiter Punkt.
    inline void setP2(const Point& p2) { mP2 = p2; }


private:
    Point mP1;
    Point mP2;
};

#endif // __LINE_H_
