// Copyright (c) 2011 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: mainwindow.h 0fa08f2d4845 2011/10/14 13:23:44 Oliver Lau <oliver@von-und-fuer-lau.de> $

#ifndef __MAINWINDOW_H_
#define __MAINWINDOW_H_

#include <QMainWindow>
#include <QTime>
#include <QString>
#include <QMapIterator>

#ifndef QT_NO_DEBUG
// a QPlainTextEdit is used for logging
#include <QPlainTextEdit>
#endif

#include "3dwidget.h"
#include "videowidget.h"
#include "depthimagewidget.h"
#include "posehelperwidget.h"
#include "nuithread.h"
#include "skeleton.h"
#include "flagsemaphore.h"
#include "speechrecognizer.h"


namespace Ui {
    class MainWindow;
}


class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    explicit MainWindow(QWidget* parent = NULL);
    ~MainWindow();

    static const QString Company;
    static const QString AppName;
    static const QString AppVersion;

public slots:
    void evaluateSkeletons(const SkeletonList&, const SkeletonList&);

private slots:
    void phraseRecognized(QString word, QString ruleName, float confidence);
    void waving(int, FlagSemaphore::Side);
    void tiltChanged(int);
    void confidenceChanged(int);

protected:
    void closeEvent(QCloseEvent*);

private: // methods
    void saveAppSettings(void);
    void restoreAppSettings(void);
    void autoAdjustTilt(void);

private:
    Ui::MainWindow *ui;

#ifndef QT_NO_DEBUG
    QPlainTextEdit* mDebugWidget;
#endif

    bool mAlreadyDetected;
    bool mHelp;
    int mCalibrationStep;
    QTime mFirstDetectionTime;
    ThreeDWidget* m3DWidget;
    VideoWidget* mVideoWidget;
    DepthImageWidget* mDepthWidget;
    PoseHelperWidget* mPoseHelperWidget;

    FlagSemaphore::FlagSemaphore* mFlags;

    NUIThread mNUIThread;

    QMapIterator<QString, FlagSemaphore::Position>* mPoseIterator;
    void nextPose(void);

    SpeechRecognizer mSpeechRecognizer;

    Skeleton mCurrentSkeleton3D;
    Skeleton mCurrentSkeleton2D;

    QTime mLastAdjustmentTime;
};

#endif // __MAINWINDOW_H_
