// Copyright (c) 2011 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: nuithread.h eb870b13e595 2011/08/31 11:17:52 Oliver Lau <oliver@von-und-fuer-lau.de> $

#ifndef __NUITHREAD_H_
#define __NUITHREAD_H_

#include <Windows.h>

#include <QThread>

#include "nui.h"

class NUIThread : public QThread
{
    Q_OBJECT
public:
    explicit NUIThread(QObject* parent = NULL);
    ~NUIThread();

    void halt(void);

    QSize depthFrameSize(void) const { return QSize(320, 240); }
    QSize videoFrameSize(void) const { return QSize(640, 480); }

protected:
    void run(void);

private:
    NUI* mNUI;

    HANDLE mEvNuiProcessStop;
    HANDLE mNextDepthFrameEvent;
    HANDLE mNextVideoFrameEvent;
    HANDLE mNextSkeletonEvent;

    HANDLE mVideoStreamHandle;
    HANDLE mDepthStreamHandle;

    void depthAlertReceived(void);
    void videoAlertReceived(void);
    void skeletonAlertReceived(void);

signals:
    void videoFrameReady(const QImage&);
    void depthFrameReady(const QImage&);
    void skeletonsReady(SkeletonList, SkeletonList);

};

#endif // __NUITHREAD_H_
