// Copyright (c) 2011 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: skeleton.h 0fa08f2d4845 2011/10/14 13:23:44 Oliver Lau <oliver@von-und-fuer-lau.de> $

#ifndef __SKELETON_H_
#define __SKELETON_H_

#include <Windows.h>
#include <Propsys.h>
#include <MSR_NuiApi.h>

#include <QtCore/QVector>
#include <QtCore/QMetaType>

#include "helper.h"
#include "point.h"
#include "flagsemaphore.h"

class Skeleton : public QVector<Point> {
public:
    Skeleton(void) : QVector<Point>() { /* ... */ }
    Skeleton(int n) : QVector<Point>(n) { /* ... */ }
    Skeleton(const Skeleton& other) : QVector<Point>(other) { /* ... */ }

    bool armPoints(FlagSemaphore::Side, int, __OUT float* angle = NULL) const;
    bool handAboveElbow(FlagSemaphore::Side) const;

    inline const Point& rightHand(void) const { return at(NUI_SKELETON_POSITION_HAND_RIGHT); }
    inline const Point& leftHand(void) const { return at(NUI_SKELETON_POSITION_HAND_LEFT); }
};

typedef QVector<Skeleton> SkeletonList;
typedef QVector<int> JointIndexList;
typedef QVector<JointIndexList> LimbList;

Q_DECLARE_METATYPE(SkeletonList)

#endif // __SKELETON_H_
