// Copyright (c) 2008-2009 Oliver Lau <oliver@von-und-fuer-lau.de>
// Alle Rechte vorbehalten.
// $Id: vector.cpp 03d56a8f9ad2 2011/10/24 08:02:28 Oliver Lau <oliver@von-und-fuer-lau.de> $

#include "vector.h"
#include "point.h"

#include <math.h>


Vector::Vector(const Point& p1, const Point& p2)
{
    mU = p2.x() - p1.x();
    mV = p2.y() - p1.y();
    mW = p2.z() - p1.z();
}


float operator*(const Vector& v1, const Vector& v2)
{
    return v1.u() * v2.u() + v1.v() * v2.v() + v1.w() * v2.w();
}


Vector operator-(const Vector& v1, const Vector& v2)
{
    return Vector(v1.u() - v2.u(), v1.v() - v2.v(), v1.w() - v2.w());
}


Vector operator+(const Vector& v1, const Vector& v2)
{
    return Vector(v1.u() + v2.u(), v1.v() + v2.v(), v1.w() + v2.w());
}


Vector operator/(const Vector& vec, float s)
{
    return Vector(vec.u()/s, vec.v()/s, vec.w()/s);
}


Vector operator*(const Vector& vec, float s)
{
    return Vector(vec.u()*s, vec.v()*s, vec.w()*s);
}


Vector operator*(float s, const Vector& vec)
{
    return Vector(vec.u()*s, vec.v()*s, vec.w()*s);
}


float Vector::length(void) const
{
    return sqrt(mU*mU + mV*mV + mW*mW);
}


inline Vector Vector::normalized(void) const
{
    const float l = this->length();
    if (l == 0.0f)
        return Vector();
    return *this / l;
}


float Vector::angleTo(const Vector& other) const
{
    return acos(this->normalized() * other.normalized());
}
