BEGIN {
    srand();
    # Datenbank
    alltime="/tmp/prefix.log";  
    # HINWEIS: Die folgenden zwei Variablen muessen an
    # die eigenen Vorgaben angepasst werden
    prefix="2001:0db8:1";
    reserved="affe";
    # Vorgaben, koennen angepasst werden!
    # absolute Gueltigkeit: 7 Tage
    AdvValidLifetime=604800;
    # bevorzugte Gueltigkeit: 24 Stunden
    AdvPreferredLifeTime=86400;
    # generate a random subnet (16 Bit)
    do {
	gensubnet();
    } while (find_in_alltime(full_prefix) == 0)
    set_newprefix(full_prefix,AdvValidLifetime,AdvPreferredLifeTime);
    setgwaddr(router_addr, AdvValidLifetime*2, AdvPreferredLifeTime*2);
    system("/etc/init.d/radvd reload");
    printf("%s;%s;%s;%s;%s\n", full_prefix, router_addr, gentime, endtime, AdvValidLifetime) >> alltime;
    exit;
}

function find_in_alltime(full_prefix)
{
    FS=";";
    erg=1;    
    while ((getline line < alltime) > 0) 
    {
		split(line, data, ";")
		if ( data[1] == full_prefix ) {
			if ( data[3] > systime() - (3*AdvValidLifetime)) {
			erg=0;
			} 
		} 
    } 
    close(alltime);
    return erg;
}

function gensubnet() {
    do {
	subnet=sprintf("%x", int(0xffff*rand()));
    } while(subnet == reserved) 
    full_prefix=prefix ":" subnet "::/64";
    router_addr=prefix ":" subnet "::1/64";
    gentime=systime();
    return;
}

function setgwaddr(addr, gw_valid_lft, gw_preferred_lft) {
    if (system("/usr/sbin/ip -6 addr add " addr " dev br-lan valid_lft " gw_valid_lft " preferred_lft " gw_preferred_lft)!=0) 
	print "Error: Can't set gateway address " addr
}

function set_newprefix(nprefix,AdvValidLifetime,AdvPreferredLifeTime) {
    system("/sbin/uci set radvd.@prefix[0].prefix=" nprefix);
    system("/sbin/uci set radvd.@prefix[0].AdvValidLifetime=" AdvValidLifetime);
    system("/sbin/uci set radvd.@prefix[0].AdvPreferredLifetime=" AdvPreferredLifeTime);
    system("/sbin/uci commit radvd");
}