#pragma warning(disable: 4996)

#include <string> 
#include <iostream> 
#include <vector>

#include <boost/signals2.hpp>
#include <boost/foreach.hpp>

float sum(float x, float y) { return x + y; }
float difference(float x, float y) { return x - y; }

template<typename Container>
struct all_values {
	typedef Container result_type;
	template<typename InputIterator>
	Container operator()(InputIterator first, InputIterator last) const {
		Container values;
		while (first != last)
			values.push_back(*first++);
		return values;
	}
};

void main(void) {
	typedef std::vector<float> result_type;
	boost::signals2::signal<float (float, float), all_values<result_type>> sig;
	sig.connect(&sum);
	sig.connect(&difference);
	result_type results = sig(5, 3);
	BOOST_FOREACH(float r, results)
		std::cout << r << std::endl;
}
