﻿Imports System.Drawing

<Runtime.InteropServices.ComVisible(True)> _
Public Class modRibbon
    Implements Office.IRibbonExtensibility

    Private ribbon As Office.IRibbonUI

    Public Sub New()
    End Sub

    Public Function GetCustomUI(ByVal ribbonID As String) As String Implements Office.IRibbonExtensibility.GetCustomUI
        ' Ribbon-Anpassung laden
        Return GetResourceText("WebPrintAddIn.ribExplorer.xml")
    End Function

#Region "Menübandrückrufe"
    '***********************************************************************************
    'Explorer-Ribbon
    '***********************************************************************************

    Public Sub ribExplorer_Load(ByVal ribbonUI As Office.IRibbonUI)
        Me.ribbon = ribbonUI
    End Sub

    ' Beim Anklicken der Menüband-Schaltfläche btnWebPrint...
    Public Sub btnWebPrint_onAction(ByVal control As Office.IRibbonControl)
        ' ... "Makro" HandleWPDocuments aufrufen, Meldungen erlaubt
        Call modMain.HandleWPDocuments(True)
    End Sub

    ' Beim Anklicken der Menüband-Schaltfläche btnInfo...
    Public Sub btnInfo_onAction(ByVal control As Office.IRibbonControl)
        ' ... "Makro" ShowInfoDialog aufrufen
        Call modMain.ShowInfoDialog()
    End Sub

    '***********************************************************************************
    'Gemeinsame Routinen
    '***********************************************************************************

    Public Function myRibbons_getAppName(ByVal control As Office.IRibbonControl) As String
        Return modMain.APPNAME
    End Function

    Public Function myRibbons_getImage(ByVal control As Office.IRibbonControl) As Bitmap
        Dim Icon As Bitmap = Nothing

        Select Case control.Id
            Case "btnWebPrint"
                Icon = New Bitmap(My.Resources.WebPrint_48x48)
            Case "btnInfo"
                Icon = New Bitmap(My.Resources.WebPrintInfo_48x48)
        End Select

        Return Icon
    End Function
#End Region

#Region "Helfer"
    Private Shared Function GetResourceText(ByVal resourceName As String) As String
        Dim asm As Reflection.Assembly = Reflection.Assembly.GetExecutingAssembly()
        Dim resourceNames() As String = asm.GetManifestResourceNames()
        For i As Integer = 0 To resourceNames.Length - 1
            If String.Compare(resourceName, resourceNames(i), StringComparison.OrdinalIgnoreCase) = 0 Then
                Using resourceReader As IO.StreamReader = New IO.StreamReader(asm.GetManifestResourceStream(resourceNames(i)))
                    If resourceReader IsNot Nothing Then
                        Return resourceReader.ReadToEnd()
                    End If
                End Using
            End If
        Next
        Return Nothing
    End Function
#End Region
End Class
