//
//  ViewController.m
//  PingPong
//
//  Created by Abgottspon Andy on 23/09/2011.
//  Copyright (c) 2011 aaweb. All rights reserved.
//

#import "SetupViewController.h"
#import "RootViewController.h"

@implementation RootViewController
@synthesize gestLibController;
@synthesize gestLibData;
@synthesize camView;


- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil;
{
    [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    
    imageArray = [[NSMutableArray alloc] initWithObjects:nil];   
    
    gestLibData = [[NSMutableDictionary alloc] init];

    return self;
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Release any cached data, images, etc that aren't in use.
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];

    nbOfPictures = 11;
    activeImg = 1;
    scrollStep = 400;
    grabInProgress = NO;
    scaleFactor = 2.0;

    // Create and add pictures to scroll view
    for (int i=1; i <= nbOfPictures; i++) {
        NSString *filename = [NSString stringWithFormat:@"photo%d.jpg", i];
        UIImage *img = [RootViewController imageWithImage:[UIImage imageNamed:filename] scaledToSize:CGSizeMake(300.0, 226.0)];
        
        UIImageView *imageView = [[UIImageView alloc] initWithImage:img];
        imageView.contentMode = UIViewContentModeScaleToFill;
        imageView.frame = CGRectMake(50.0 + (400.0 *(i-1)), 150.0, 300.0, 226.0);
        imageView.center = CGPointMake(imageView.frame.origin.x + 150, imageView.frame.origin.y + 113.0);
        [scrollView addSubview:imageView];
        
        [imageArray addObject:imageView];
    }
    
    
    // Init scroll view
    scrollView.contentSize = CGSizeMake(40*nbOfPictures,560);
    [self scrollToActiveImage];
    
    
    // Gesture Library setup
    gestLibController = [[SetupViewController alloc] initWithRootVC:self];
    gestLibController.view.frame = CGRectMake(336, 403, gestLibController.view.frame.size.width, gestLibController.view.frame.size.height);  
    [gestLibController.view setHidden:NO];
    
    //gestLibView = [gestLibController view];
    [self.view addSubview:[gestLibController view]];
    
    
    // Set ratio from camera image to display view
    camViewRatio = camView.frame.size.width / gestLibController.videoWidth;

}

- (IBAction)update
{
    // Make variables a bit more readable
    h1x = [[gestLibData objectForKey:@"handOnePosX"] intValue];
    h1y = [[gestLibData objectForKey:@"handOnePosY"] intValue];
    h2x = [[gestLibData objectForKey:@"handTwoPosX"] intValue];
    h2y = [[gestLibData objectForKey:@"handTwoPosY"] intValue];
   
    // Rotate for double grabs
//    if(doubleGrabbed) {
//        UIImageView *imageView = (UIImageView *)[imageArray objectAtIndex:activeImg];
//        
//        int scaleFactor = [[gestLibData objectForKey:@"handOnePosX"] intValue] - [[gestLibData objectForKey:@"handTwoPosX"] intValue];
//        
//        bool reverse = ([[gestLibData objectForKey:@"handTwoPosX"] intValue] > [[gestLibData objectForKey:@"handOnePosX"] intValue]);
//        float rotateFactor = (reverse) ? h2y - h1y : h1y - h2y;
//        
//        imageView.transform = CGAffineTransformMakeRotation(rotateFactor *0.3 / 200.0 * 2*3.14159265); //rotation in radians
//        imageView.transform = CGAffineTransformMakeScale(scaleFactor, scaleFactor);
//    }
    
    // Position little cursor buttons
    btnHand1.frame = CGRectMake(h1x * camViewRatio, h1y * camViewRatio, btnHand1.frame.size.width, btnHand1.frame.size.height);
    btnHand2.frame = CGRectMake(h2x * camViewRatio, h2y * camViewRatio, btnHand2.frame.size.width, btnHand2.frame.size.height);
    
    // Hide unused hand cursors
    btnHand1.hidden = ([[gestLibData objectForKey:@"nbOfHands"] intValue] == 0);
    btnHand2.hidden = ([[gestLibData objectForKey:@"nbOfHands"] intValue] != 2);
    
    // Update position when grabbed
    if(grabInProgress)
    {
        int handX = (grabHand == 0) ? h1x*camViewRatio : h2x*camViewRatio;
        int handY = (grabHand == 0) ? h1y*camViewRatio : h2y*camViewRatio;

        UIImageView *imageView = (UIImageView *)[imageArray objectAtIndex:activeImg];
        imageView.frame = CGRectMake(handX - grabPoint.x, handY - grabPoint.y, imageView.frame.size.width, imageView.frame.size.height);
        
        
        // Hovering over buttons
        btnFav.alpha = ([self isPoint:CGPointMake(handX, handY) withinRect:btnFav.frame]) ? 1.0 : 0.5;
        btnTrash.alpha = ([self isPoint:CGPointMake(handX, handY) withinRect:btnTrash.frame]) ? 1.0 : 0.5;
    } else {
        btnFav.alpha = 0.5;
        btnTrash.alpha = 0.5;
    }

    // Cancel gesture when hands are gone
    if([[gestLibData objectForKey:@"nbOfHands"] intValue] == 0) 
    {
//        [self cancelGrab];
    }
    
}

- (void)scrollToActiveImage
{
    NSLog(@"Scroll to active image %d", activeImg);
    
    CGPoint offset = CGPointMake((activeImg-1)*scrollStep + 88, 0);
    [scrollView setContentOffset:offset animated:YES];
    
    // Make active image bigger
    UIImageView *imageView = (UIImageView *)[imageArray objectAtIndex:activeImg];
    [UIView animateWithDuration:0.5 
                          delay:0
                        options:UIViewAnimationOptionBeginFromCurrentState
                     animations:(void (^)(void)) ^{
                         imageView.transform = CGAffineTransformScale(imageView.transform, scaleFactor, scaleFactor);
                     }
                     completion:^(BOOL finished){
                         //
                     }];
    
}

- (IBAction)grabEvent:(int)handId
{
    int handX = (handId == 0) ? h1x*camViewRatio : h2x*camViewRatio;
    int handY = (handId == 0) ? h1y*camViewRatio : h2y*camViewRatio;
    
    
    // Check for position of grab
    if([self isPoint:CGPointMake(handX, handY) withinRect:btnPrev.frame]) 
    {
        [self prevPicture:nil];
    }
    else if([self isPoint:CGPointMake(handX, handY) withinRect:btnNext.frame]) 
    {
        [self nextPicture:nil];
    }
    else
    {
        // Image grabbed
        UIImageView *imageView = (UIImageView *)[imageArray objectAtIndex:activeImg];
        
        imageView.alpha = 0.8;
        grabPoint = CGPointMake(handX - imageView.frame.origin.x, handY - imageView.frame.origin.y);
        grabInProgress = YES;
        grabHand = handId;
        grabbedImageFrame = imageView.frame;
    }
}

- (void)cancelGrab
{
    grabInProgress = NO;

    // Restore active image
    UIImageView *imageView = (UIImageView *)[imageArray objectAtIndex:activeImg];
//    imageView.contentMode = UIViewContentModeScaleToFill;
//    imageView.frame = CGRectMake(50.0 + (400.0 *(activeImg)), 150.0, 300.0, 226.0);
    imageView.alpha = 1.0;
    imageView.frame = grabbedImageFrame;
}

- (void)archiveImage:(int)imgNb folder:(int)isTrash
{
    NSLog(@"Save to %d@", isTrash);
    
    // Remove picture from scrollview
    UIImageView *imageView = (UIImageView *)[imageArray objectAtIndex:activeImg];
    [UIView animateWithDuration:0.5 
                          delay:0
                        options:UIViewAnimationOptionBeginFromCurrentState
                     animations:(void (^)(void)) ^{
                         imageView.transform = CGAffineTransformMakeScale(5.0, 5.0);
                         imageView.alpha = 0.0;
                     }
                     completion:^(BOOL finished){
                     }];
    
    // Reorder views
    for(int i=activeImg+1; i < [imageArray count]; i++)
    {
        UIImageView *nextImageView = (UIImageView *)[imageArray objectAtIndex:i];
        [UIView animateWithDuration:1 
                              delay:0
                            options:UIViewAnimationOptionBeginFromCurrentState
                         animations:(void (^)(void)) ^{
                             nextImageView.transform = CGAffineTransformTranslate(nextImageView.transform,-scrollStep, 0);
                         }
                         completion:^(BOOL finished){
                             if(i == activeImg+1) {
                                 [self scrollToActiveImage];
                             }
                         }];
    }
    
    [imageArray removeObjectAtIndex:activeImg];
    
    if([imageArray count] == activeImg) {
        activeImg--;
        [self scrollToActiveImage];
    }

}


- (IBAction)releaseEvent:(int)handId
{
    int handX = (handId == 0) ? h1x*camViewRatio : h2x*camViewRatio;
    int handY = (handId == 0) ? h1y*camViewRatio : h2y*camViewRatio;

    if(grabInProgress && handId == grabHand) {
        [self cancelGrab];
        
        // Put it in the right archive
        if([self isPoint:CGPointMake(handX, handY) withinRect:btnFav.frame]) {
            [self archiveImage:activeImg folder:0];
        } else if([self isPoint:CGPointMake(handX, handY) withinRect:btnTrash.frame]) {
            [self archiveImage:activeImg folder:1];
        }
    }
}

- (IBAction)doubleGrabEvent
{
    doubleGrabbed = YES;
}

- (IBAction)doubleReleaseEvent
{
    doubleGrabbed = NO;
}

- (IBAction)swipeLeftEvent:(int)handId
{
    
}

- (IBAction)swipeRightEvent:(int)handId
{
    
}

- (IBAction)showSetup:(id)sender
{
    [gestLibController.view setHidden:NO];
}

- (IBAction)prevPicture:(id)sender
{
    if(activeImg == 0 || grabInProgress) {
        return;
    }
    
    UIImageView *imageView = (UIImageView *)[imageArray objectAtIndex:activeImg];
    imageView.transform = CGAffineTransformScale(imageView.transform,1.0/scaleFactor, 1.0/scaleFactor);

    activeImg--;
    [self scrollToActiveImage];
}

- (IBAction)nextPicture:(id)sender
{
    if(activeImg == [imageArray count]-1 || grabInProgress) {
        return;
    }

    UIImageView *imageView = (UIImageView *)[imageArray objectAtIndex:activeImg];
    imageView.transform = CGAffineTransformScale(imageView.transform, 1.0/scaleFactor, 1.0/scaleFactor);

    activeImg++;
    [self scrollToActiveImage];
}

+ (UIImage *)imageWithImage:(UIImage *)image scaledToSize:(CGSize)newSize {
    UIGraphicsBeginImageContext(newSize);
    [image drawInRect:CGRectMake(0, 0, newSize.width, newSize.height)];
    UIImage *newImage = UIGraphicsGetImageFromCurrentImageContext();    
    UIGraphicsEndImageContext();
    return newImage;
}

- (BOOL)isPoint:(CGPoint)p withinRect:(CGRect)rect
{
    if(p.x >= rect.origin.x && p.x <= rect.origin.x + rect.size.width &&
       p.y >= rect.origin.y && p.y <= rect.origin.y + rect.size.height) 
    {
        return YES;
    }
    return NO;
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
}

- (void)viewWillDisappear:(BOOL)animated
{
	[super viewWillDisappear:animated];
}

- (void)viewDidDisappear:(BOOL)animated
{
	[super viewDidDisappear:animated];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    return YES;
}

- (void)dealloc {
	[imageArray release];
	[gestLibData release];
    [super dealloc];
}

@end
