//
//  SetupViewController.h
//  Meteora
//
//  Created by Abgottspon Andy on 24/09/2011.
//  Copyright (c) 2011 aaweb. All rights reserved.
//

#pragma once

#import <UIKit/UIKit.h>
#import "GestureLibrary.h"
#import "RootViewController.h"

@interface SetupViewController : UIViewController
{
    GestureLibrary gestLib;
    IBOutlet UIImageView *camImg;
    IBOutlet UILabel *lblHand1;
    IBOutlet UILabel *lblHand2;
    IBOutlet UILabel *lblColor;
    IBOutlet UISlider *thresholdSlider;
    IBOutlet UISwitch *enabledSwitch;
    NSTimer *timer;
    RootViewController *rootVC;
    
    int videoWidth;
    int videoHeight;
    float camViewScale;
    float camScreenScale;
    float fps;
}

@property (nonatomic, assign) GestureLibrary gestLib;
@property (nonatomic, assign) int videoWidth;
@property (nonatomic, assign) int videoHeight;

- (id)initWithRootVC:(RootViewController *)vc;
- (void)update;
- (void)handleSingleTap:(UIGestureRecognizer *)sender;
- (IBAction)done:(id)sender;
- (IBAction)thresholdChanged:(UISlider *)sender;
- (IBAction)enabledChanged:(UISwitch *)sender;

@end
