// XYPlotter1.h: Schnittstelle fr die Klasse CXYPlotter.
//
//////////////////////////////////////////////////////////////////////

/*
	COPYRIGHT 2011 Christian Nolte
    
    This file is part of myengrave.

    myengrave is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    myengrave is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with myengrave.  If not, see <http://www.gnu.org/licenses/>.

    Diese Datei ist Teil von myengrave.

    myengrave ist Freie Software: Sie knnen es unter den Bedingungen
    der GNU General Public License, wie von der Free Software Foundation,
    Version 3 der Lizenz oder (nach Ihrer Option) jeder spteren
    verffentlichten Version, weiterverbreiten und/oder modifizieren.

    myengrave wird in der Hoffnung, dass es ntzlich sein wird, aber
    OHNE JEDE GEWHELEISTUNG, bereitgestellt; sogar ohne die implizite
    Gewhrleistung der MARKTFHIGKEIT oder EIGNUNG FR EINEN BESTIMMTEN ZWECK.
    Siehe die GNU General Public License fr weitere Details.

    Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
    Programm erhalten haben. Wenn nicht, siehe <http://www.gnu.org/licenses/>.

*/


#if !defined(AFX_XYPLOTTER1_H__49F782CC_16F1_46B9_8279_6C0A56F50F42__INCLUDED_)
#define AFX_XYPLOTTER1_H__49F782CC_16F1_46B9_8279_6C0A56F50F42__INCLUDED_

#include "Stepper.h"	// Hinzugefgt von der Klassenansicht
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CXYPlotter  
{
public:
	void GotoA(int x, int y);
	void DrawCircle(int x0, int y0,int radius);
	void MotorStop(void);
	void LaserON(void);
	void LaserOFF(void);
	void Move(signed char dx, signed char dy);
	CXYPlotter(void);
	virtual ~CXYPlotter(void);

private:
	int cur_y;
	int cur_x;
	CStepper y_crtl;
	CStepper x_crtl;
	unsigned char LaserState;
	HANDLE hComm;
};

#endif // !defined(AFX_XYPLOTTER1_H__49F782CC_16F1_46B9_8279_6C0A56F50F42__INCLUDED_)
