﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Windows.UI;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Media;

namespace Actien.Common
{
    /// <summary>
    /// Wertkonverter, der decimal-Wete anhand ihres Vorzeichens in 
    /// Farbwerte übersetzt.
    /// </summary>
    public sealed class SignToColorConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, string language)
        {
            decimal decVal = 0;
            if (value is decimal)
                decVal = (decimal)value;
            SolidColorBrush result = new SolidColorBrush();
            if (decVal >= 0.01m)
            {
                result.Color = Color.FromArgb(255, 0, 223, 0);
            }
            else if (decVal <= -0.01m)
            {
                result.Color = Color.FromArgb(255, 223, 0, 0);
            }
            else
            {
                result.Color = Color.FromArgb(0xdf, 255, 255, 255);
            }
            return result;
        }

        public object ConvertBack(object value, Type targetType, object parameter, string language)
        {
            throw new NotImplementedException();
        }
    }
}
