/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.XmlResourceParser;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cordova.CallbackServer;
import org.apache.cordova.CordovaChromeClient;
import org.apache.cordova.CordovaWebViewClient;
import org.apache.cordova.api.CordovaInterface;
import org.apache.cordova.api.LOG;
import org.apache.cordova.api.PluginManager;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CordovaWebView
extends WebView {
    public static final String TAG = "CordovaWebView";
    private ArrayList<Pattern> whiteList = new ArrayList();
    private HashMap<String, Boolean> whiteListCache = new HashMap();
    private ArrayList<Integer> keyDownCodes = new ArrayList();
    private ArrayList<Integer> keyUpCodes = new ArrayList();
    public PluginManager pluginManager;
    public CallbackServer callbackServer;
    private CordovaInterface cordova;
    CordovaWebViewClient viewClient;
    private CordovaChromeClient chromeClient;
    private String url;
    String baseUrl;
    private Stack<String> urls = new Stack();
    boolean useBrowserHistory = false;
    int loadUrlTimeout = 0;
    private boolean bound;
    private boolean volumedownBound;
    private boolean volumeupBound;

    public CordovaWebView(Context context) {
        super(context);
        if (CordovaInterface.class.isInstance(context)) {
            this.cordova = (CordovaInterface)context;
        } else {
            Log.d((String)TAG, (String)"Your activity must implement CordovaInterface to work");
        }
        this.loadConfiguration();
        this.setup();
    }

    public CordovaWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (CordovaInterface.class.isInstance(context)) {
            this.cordova = (CordovaInterface)context;
        } else {
            Log.d((String)TAG, (String)"Your activity must implement CordovaInterface to work");
        }
        this.setWebChromeClient(new CordovaChromeClient(this.cordova, this));
        this.setWebViewClient(new CordovaWebViewClient(this.cordova, this));
        this.loadConfiguration();
        this.setup();
    }

    public CordovaWebView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (CordovaInterface.class.isInstance(context)) {
            this.cordova = (CordovaInterface)context;
        } else {
            Log.d((String)TAG, (String)"Your activity must implement CordovaInterface to work");
        }
        this.setWebChromeClient(new CordovaChromeClient(this.cordova, this));
        this.setWebViewClient(new CordovaWebViewClient(this.cordova, this));
        this.loadConfiguration();
        this.setup();
    }

    public CordovaWebView(Context context, AttributeSet attrs, int defStyle, boolean privateBrowsing) {
        super(context, attrs, defStyle, privateBrowsing);
        if (CordovaInterface.class.isInstance(context)) {
            this.cordova = (CordovaInterface)context;
        } else {
            Log.d((String)TAG, (String)"Your activity must implement CordovaInterface to work");
        }
        this.setWebChromeClient(new CordovaChromeClient(this.cordova));
        this.setWebViewClient(new CordovaWebViewClient(this.cordova));
        this.loadConfiguration();
        this.setup();
    }

    private void setup() {
        this.setInitialScale(0);
        this.setVerticalScrollBarEnabled(false);
        this.requestFocusFromTouch();
        WebSettings settings = this.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setJavaScriptCanOpenWindowsAutomatically(true);
        settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        if (Build.VERSION.SDK_INT < 11) {
            settings.setNavDump(true);
        }
        settings.setDatabaseEnabled(true);
        String databasePath = this.cordova.getActivity().getApplicationContext().getDir("database", 0).getPath();
        settings.setDatabasePath(databasePath);
        settings.setDomStorageEnabled(true);
        settings.setGeolocationEnabled(true);
        try {
            this.pluginManager = new PluginManager(this, this.cordova);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setWebViewClient(CordovaWebViewClient client) {
        this.viewClient = client;
        super.setWebViewClient((WebViewClient)client);
    }

    public void setWebChromeClient(CordovaChromeClient client) {
        this.chromeClient = client;
        super.setWebChromeClient((WebChromeClient)client);
    }

    public void addWhiteListEntry(String origin, boolean subdomains) {
        try {
            if (origin.compareTo("*") == 0) {
                LOG.d(TAG, "Unlimited access to network resources");
                this.whiteList.add(Pattern.compile(".*"));
            } else if (subdomains) {
                if (origin.startsWith("http")) {
                    this.whiteList.add(Pattern.compile(origin.replaceFirst("https?://", "^https?://(.*\\.)?")));
                } else {
                    this.whiteList.add(Pattern.compile("^https?://(.*\\.)?" + origin));
                }
                LOG.d(TAG, "Origin to allow with subdomains: %s", origin);
            } else {
                if (origin.startsWith("http")) {
                    this.whiteList.add(Pattern.compile(origin.replaceFirst("https?://", "^https?://")));
                } else {
                    this.whiteList.add(Pattern.compile("^https?://" + origin));
                }
                LOG.d(TAG, "Origin to allow: %s", origin);
            }
        }
        catch (Exception e) {
            LOG.d(TAG, "Failed to add origin %s", origin);
        }
    }

    public boolean isUrlWhiteListed(String url) {
        if (this.whiteListCache.get(url) != null) {
            return true;
        }
        for (Pattern p : this.whiteList) {
            Matcher m = p.matcher(url);
            if (!m.find()) continue;
            this.whiteListCache.put(url, true);
            return true;
        }
        return false;
    }

    public void loadUrl(String url) {
        if (url.equals("about:blank") || url.startsWith("javascript:")) {
            this.loadUrlNow(url);
        } else {
            String initUrl = this.getProperty("url", null);
            if (initUrl == null || this.urls.size() > 0) {
                this.loadUrlIntoView(url);
            } else {
                this.loadUrlIntoView(initUrl);
            }
        }
    }

    public void loadUrl(String url, int time) {
        String initUrl = this.getProperty("url", null);
        if (initUrl == null || this.urls.size() > 0) {
            this.loadUrlIntoView(url, time);
        } else {
            this.loadUrlIntoView(initUrl);
        }
    }

    public void loadUrlIntoView(final String url) {
        LOG.d(TAG, ">>> loadUrl(" + url + ")");
        this.url = url;
        if (this.baseUrl == null) {
            int i = url.lastIndexOf(47);
            this.baseUrl = i > 0 ? url.substring(0, i + 1) : this.url + "/";
            this.pluginManager.init();
            if (!this.useBrowserHistory) {
                this.urls.push(url);
            }
        }
        final CordovaWebView me = this;
        final int currentLoadUrlTimeout = me.loadUrlTimeout;
        final int loadUrlTimeoutValue = Integer.parseInt(this.getProperty("loadUrlTimeoutValue", "20000"));
        final Runnable loadError = new Runnable(){

            public void run() {
                me.stopLoading();
                LOG.e(CordovaWebView.TAG, "CordovaWebView: TIMEOUT ERROR!");
                if (CordovaWebView.this.viewClient != null) {
                    CordovaWebView.this.viewClient.onReceivedError(me, -6, "The connection to the server was unsuccessful.", url);
                }
            }
        };
        final Runnable timeoutCheck = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        this.wait(loadUrlTimeoutValue);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (me.loadUrlTimeout == currentLoadUrlTimeout) {
                    me.cordova.getActivity().runOnUiThread(loadError);
                }
            }
        };
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            public void run() {
                Thread thread = new Thread(timeoutCheck);
                thread.start();
                me.loadUrlNow(url);
            }
        });
    }

    private void loadUrlNow(String url) {
        LOG.d(TAG, ">>> loadUrlNow()");
        super.loadUrl(url);
    }

    public void loadUrlIntoView(String url, int time) {
        if (!url.startsWith("javascript:") && this.urls.size() <= 0 && !this.canGoBack()) {
            LOG.d(TAG, "DroidGap.loadUrl(%s, %d)", url, time);
            this.postMessage("splashscreen", "show");
        }
        this.loadUrlIntoView(url);
    }

    public void sendJavascript(String statement) {
        if (this.callbackServer != null) {
            this.callbackServer.sendJavascript(statement);
        }
    }

    public void postMessage(String id, Object data) {
        if (this.pluginManager != null) {
            this.pluginManager.postMessage(id, data);
        }
    }

    public String peekAtUrlStack() {
        if (this.urls.size() > 0) {
            return this.urls.peek();
        }
        return "";
    }

    public void pushUrl(String url) {
        this.urls.push(url);
    }

    public boolean backHistory() {
        if (super.canGoBack()) {
            super.goBack();
            return true;
        }
        if (this.urls.size() > 1) {
            this.urls.pop();
            String url = this.urls.pop();
            this.loadUrl(url);
            return true;
        }
        return false;
    }

    public boolean canGoBack() {
        if (super.canGoBack()) {
            return true;
        }
        return this.urls.size() > 1;
    }

    public void showWebPage(String url, boolean openExternal, boolean clearHistory, HashMap<String, Object> params) {
        LOG.d(TAG, "showWebPage(%s, %b, %b, HashMap", url, openExternal, clearHistory);
        if (clearHistory) {
            this.clearHistory();
        }
        if (!openExternal) {
            if (url.startsWith("file://") || url.indexOf(this.baseUrl) == 0 || this.isUrlWhiteListed(url)) {
                if (clearHistory) {
                    this.urls.clear();
                }
                this.loadUrl(url);
            } else {
                LOG.w(TAG, "showWebPage: Cannot load URL into webview since it is not in white list.  Loading into browser instead. (URL=" + url + ")");
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    this.cordova.getActivity().startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    LOG.e(TAG, "Error loading url " + url, e);
                }
            }
        } else {
            try {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)url));
                this.cordova.getActivity().startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                LOG.e(TAG, "Error loading url " + url, e);
            }
        }
    }

    private void loadConfiguration() {
        int id = this.getResources().getIdentifier("config", "xml", this.cordova.getActivity().getPackageName());
        if (id == 0) {
            id = this.getResources().getIdentifier("cordova", "xml", this.cordova.getActivity().getPackageName());
            Log.i((String)"CordovaLog", (String)"config.xml missing, reverting to cordova.xml");
        }
        if (id == 0) {
            LOG.i("CordovaLog", "cordova.xml missing. Ignoring...");
            return;
        }
        XmlResourceParser xml = this.getResources().getXml(id);
        int eventType = -1;
        while (eventType != 1) {
            if (eventType == 2) {
                String strNode = xml.getName();
                if (strNode.equals("access")) {
                    String origin = xml.getAttributeValue(null, "origin");
                    String subdomains = xml.getAttributeValue(null, "subdomains");
                    if (origin != null) {
                        this.addWhiteListEntry(origin, subdomains != null && subdomains.compareToIgnoreCase("true") == 0);
                    }
                } else if (strNode.equals("log")) {
                    String level = xml.getAttributeValue(null, "level");
                    LOG.i("CordovaLog", "Found log level %s", level);
                    if (level != null) {
                        LOG.setLogLevel(level);
                    }
                } else if (strNode.equals("preference")) {
                    String name = xml.getAttributeValue(null, "name");
                    String value = xml.getAttributeValue(null, "value");
                    LOG.i("CordovaLog", "Found preference for %s=%s", name, value);
                    Log.d((String)"CordovaLog", (String)("Found preference for " + name + "=" + value));
                    this.cordova.getActivity().getIntent().putExtra(name, value);
                }
            }
            try {
                eventType = xml.next();
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.useBrowserHistory = "true".equals(this.getProperty("useBrowserHistory", "false"));
        if ("true".equals(this.getProperty("fullscreen", "false"))) {
            this.cordova.getActivity().getWindow().clearFlags(2048);
            this.cordova.getActivity().getWindow().setFlags(1024, 1024);
        }
    }

    public String getProperty(String name, String defaultValue) {
        Bundle bundle = this.cordova.getActivity().getIntent().getExtras();
        if (bundle == null) {
            return defaultValue;
        }
        Object p = bundle.get(name);
        if (p == null) {
            return defaultValue;
        }
        return p.toString();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.keyDownCodes.contains(keyCode)) {
            if (keyCode == 25) {
                LOG.d(TAG, "Down Key Hit");
                this.loadUrl("javascript:cordova.fireDocumentEvent('volumedownbutton');");
                return true;
            }
            if (keyCode == 24) {
                LOG.d(TAG, "Up Key Hit");
                this.loadUrl("javascript:cordova.fireDocumentEvent('volumeupbutton');");
                return true;
            }
            return super.onKeyDown(keyCode, event);
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        Log.d((String)TAG, (String)"KeyDown has been triggered on the view");
        if (keyCode == 4) {
            if (this.bound) {
                this.loadUrl("javascript:cordova.fireDocumentEvent('backbutton');");
                return true;
            }
            return this.backHistory();
        }
        if (keyCode == 82) {
            this.loadUrl("javascript:cordova.fireDocumentEvent('menubutton');");
            return super.onKeyUp(keyCode, event);
        }
        if (keyCode == 84) {
            this.loadUrl("javascript:cordova.fireDocumentEvent('searchbutton');");
            return true;
        }
        if (this.keyUpCodes.contains(keyCode)) {
            return super.onKeyUp(keyCode, event);
        }
        Log.d((String)TAG, (String)"KeyUp has been triggered on the view");
        return false;
    }

    public void bindButton(boolean override) {
        this.bound = override;
    }

    public void bindButton(String button, boolean override) {
        if (button.compareTo("volumeup") == 0) {
            this.keyDownCodes.add(24);
        } else if (button.compareTo("volumedown") == 0) {
            this.keyDownCodes.add(25);
        }
    }

    public void bindButton(int keyCode, boolean keyDown, boolean override) {
        if (keyDown) {
            this.keyDownCodes.add(keyCode);
        } else {
            this.keyUpCodes.add(keyCode);
        }
    }

    public boolean isBackButtonBound() {
        return this.bound;
    }
}

