﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;


namespace Gesundheitskarte
{
    public partial class PinDialog : Form
    {

        private String value1 = null;
        private String value2 = null;


        /// <summary>
        /// Konstruktor fuer PIN-Eingabe nur mit neuer PIN (Transport_PIN_Leerpin_1 hat kein oldSecret)
        /// </summary>
        /// <param name="titel">Titel des Dialogfensters</param>
        /// <param name="text">Name der PIN</param>
        /// <returns></returns>
        public PinDialog(string titel, string text)
        {
            InitializeComponent();

            this.Text = titel;

            // Es gibt kein altes Passwort
            labelPIN1.Text = "Alte PIN";
            labelPIN1.Enabled = false;
            textBox1.Enabled = false;
            checkBox1.Enabled = false;
            
            labelPIN2.Text = text;
            labelPIN3.Text = "Wiederholung:";

            textBox2.KeyPress += new KeyPressEventHandler(textBox2_KeyPress);
            textBox3.KeyPress += new KeyPressEventHandler(textBox3_KeyPress);
        }


        /// <summary>
        /// Konstruktor fuer PIN-Eingabe mit alter und neuer PIN
        /// </summary>
        /// <param name="titel">Titel des Dialogfensters</param>
        /// <param name="text">Name der PIN</param>
        /// <returns></returns>
        public PinDialog(string titel, string text1, string text2)
        {
            InitializeComponent();

            this.Text = titel;

            labelPIN1.Text = text1;
            labelPIN2.Text = text2;
            labelPIN3.Text = "Wiederholung:";

            textBox1.KeyPress += new KeyPressEventHandler(textBox1_KeyPress);
            textBox2.KeyPress += new KeyPressEventHandler(textBox2_KeyPress);
            textBox3.KeyPress += new KeyPressEventHandler(textBox3_KeyPress);
        }


        /// <summary>
        /// Nur die Eingabe von Zahlen und Steuerzeichen in textBox1 (alte PIN) zulassen
        /// </summary>
        /// <returns></returns>
        private void textBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (!Char.IsDigit(e.KeyChar) && !Char.IsControl(e.KeyChar))
                e.Handled = true;
        }


        /// <summary>
        /// Nur die Eingabe von Zahlen und Steuerzeichen in textBox2 (neue PIN) zulassen
        /// </summary>
        /// <returns></returns>
        private void textBox2_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (!Char.IsDigit(e.KeyChar) && !Char.IsControl(e.KeyChar))
                e.Handled = true;
        }


        /// <summary>
        /// Nur die Eingabe von Zahlen und Steuerzeichen in textBox2 (neue PIN) zulassen
        /// </summary>
        /// <returns></returns>
        private void textBox3_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (!Char.IsDigit(e.KeyChar) && !Char.IsControl(e.KeyChar))
                e.Handled = true;
        }


        /// <summary>
        /// Umschalten der PIN-Ansicht zwischen Klartext und dem 
        /// Passwortzeichen * fuer die alte PIN
        /// </summary>
        /// <returns></returns>
        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox1.Checked)
                textBox1.PasswordChar = '\0'; // Paswortmaskierung ausschalten
            else
                textBox1.PasswordChar = '*'; // Paswortmaskierung einschalten
        }

        /// <summary>
        /// Umschalten der PIN-Ansicht zwischen Klartext und dem 
        /// Passwortzeichen * fuer die neue PIN
        /// </summary>
        /// <returns></returns>
        private void checkBox2_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox2.Checked)
            {
                textBox2.PasswordChar = '\0'; // Paswortmaskierung ausschalten
                textBox3.PasswordChar = '\0';
            }
            else
            {
                textBox2.PasswordChar = '*';  // Paswortmaskierung einschalten      
                textBox3.PasswordChar = '*';
            }
        }

        /// <summary>
        /// Reaktion auf Auswahl des OK-Buttons
        /// </summary>
        /// <returns></returns>
        private void buttonOK_Click(object sender, EventArgs e)
        {
            if (textBox2.Text == textBox3.Text)
            {
                DialogResult = DialogResult.OK;
                value1 = textBox1.Text;
                value2 = textBox2.Text;
                this.Close();
            }
            else
                MessageBox.Show("Neue PIN und Wiederholung dieser PIN stimmen nicht überein!!", "Fehler",
                                MessageBoxButtons.OK, MessageBoxIcon.Error);
        }

        /// <summary>
        /// Reaktion auf Auswahl des Cancel-Buttons
        /// </summary>
        /// <returns></returns>
        private void buttonCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            this.Close();
        }

        /// <summary>
        /// Abfrage PIN1
        /// </summary>
        /// <returns>PIN1 als String</returns>
        public string Value
        {
            get
            {
                return (value1);
            }
        }

        /// <summary>
        /// Abfrage PIN2
        /// </summary>
        /// <returns>PIN2 als String</returns>
        public string Value2
        {
            get
            {
                return (value2);
            }
        }

    }
}
