using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using Sanford.Multimedia;
using Sanford.Multimedia.Midi;
using Sanford.Multimedia.Midi.UI;


namespace SequencerDemo
{
    public partial class Form1 : Form
    {

        private bool closing = false;

        private OutputDevice outDevice = null;

        private int outDeviceID = 0;

        private InputDevice inDevice = null;

        private SynchronizationContext context;

        private OutputDeviceDialog outDialog = new OutputDeviceDialog();

        private int zaehler = 1;

 //       private void HandleChannelMessageReceived(object sender, ChannelMessageEventArgs e);

        public Form1()
        {
            InitializeComponent();            
        }

        protected override void OnLoad(EventArgs e)
        {
            if(OutputDevice.DeviceCount == 0)
            {
                MessageBox.Show("No MIDI output devices available.", "Error!",
                    MessageBoxButtons.OK, MessageBoxIcon.Stop);

                Close();
            }
            else
            {
                try
                {
                    outDeviceID = OutputDevice.DeviceCount -1;
                    outDevice = new OutputDevice(outDeviceID);

                }
                catch(Exception ex)
                {
                    MessageBox.Show(ex.Message, "Error!",
                        MessageBoxButtons.OK, MessageBoxIcon.Stop);

                    Close();
                }
            }
            if (InputDevice.DeviceCount == 0)
            {
                MessageBox.Show("No MIDI input devices available.", "Error!",
                    MessageBoxButtons.OK, MessageBoxIcon.Stop);                
            }
            else
            {
                try
                {
                    context = SynchronizationContext.Current;

                    inDevice = new InputDevice(0);
                    inDevice.ChannelMessageReceived += HandleChannelMessageReceived;
                    inDevice.SysCommonMessageReceived += HandleSysCommonMessageReceived;
                    inDevice.SysExMessageReceived += HandleSysExMessageReceived;
 //                   inDevice.SysRealtimeMessageReceived += HandleSysRealtimeMessageReceived;
                    inDevice.Error += new EventHandler<Sanford.Multimedia.ErrorEventArgs>(inDevice_Error);
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message, "Error!",
                        MessageBoxButtons.OK, MessageBoxIcon.Stop);
                    Close();
                }
            }


            base.OnLoad(e);
        }

        protected override void OnClosing(CancelEventArgs e)
        {
            closing = true;

            base.OnClosing(e);
        }

        protected override void OnClosed(EventArgs e)
        {

            if(outDevice != null)
            {
                outDevice.Dispose();
            }

            if (inDevice != null)
            {
                inDevice.Close();
            }

            base.OnClosed(e);
        }

        private void inDevice_Error(object sender, Sanford.Multimedia.ErrorEventArgs e)
        {
            MessageBox.Show(e.Error.Message, "Error!",
                   MessageBoxButtons.OK, MessageBoxIcon.Stop);
        }

        private void openToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string fileName = "test";

        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void outputDeviceToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (OutputDevice.DeviceCount == 0)
            {
                MessageBox.Show("No MIDI output devices available.", "Error!",
                    MessageBoxButtons.OK, MessageBoxIcon.Stop);

                Close();
            }
            else
            {
                outDialog.ShowDialog();
                outDeviceID = outDialog.OutputDeviceID;
                try
                {
                    if (outDevice != null)
                    {
                        outDevice.Dispose();
                    }
                    outDevice = new OutputDevice(outDeviceID);

                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message, "Error!",
                        MessageBoxButtons.OK, MessageBoxIcon.Stop);

                    // Close();
                }
            }

            if (InputDevice.DeviceCount == 0)
            {
                MessageBox.Show("No MIDI input devices available.", "Error!",
                    MessageBoxButtons.OK, MessageBoxIcon.Stop);
            }
            else
            {
                if (inDevice != null)
                {
                    inDevice.Close();
                }

                try
                {
                    context = SynchronizationContext.Current;

                    inDevice = new InputDevice(0);
                    inDevice.ChannelMessageReceived += HandleChannelMessageReceived;
                    inDevice.SysCommonMessageReceived += HandleSysCommonMessageReceived;
                    inDevice.SysExMessageReceived += HandleSysExMessageReceived;
                    //                   inDevice.SysRealtimeMessageReceived += HandleSysRealtimeMessageReceived;
                    inDevice.Error += new EventHandler<Sanford.Multimedia.ErrorEventArgs>(inDevice_Error);
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message, "Error!",
                        MessageBoxButtons.OK, MessageBoxIcon.Stop);
                    // Close();
                }
            }

        }

        private void aboutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            AboutDialog dlg = new AboutDialog();

            dlg.ShowDialog();
        }

        private void HandleChannelMessageReceived(object sender, ChannelMessageEventArgs e)
        {
            int caseSwitch = e.Message.Data1;
            switch (caseSwitch)
            {
                case 102: comboBox1.SelectedIndex = e.Message.Data2;
                    break;
                case 103: trackBar1.Value = e.Message.Data2; // 103
                    label1.Text = e.Message.Data2.ToString();
                    break;
                case 104: trackBar2.Value = e.Message.Data2;
                    label2.Text = e.Message.Data2.ToString();
                    break;
                case 105: trackBar3.Value = e.Message.Data2;
                    label3.Text = e.Message.Data2.ToString();
                    break;
                case 106: trackBar4.Value = e.Message.Data2;
                    label4.Text = e.Message.Data2.ToString();
                    break;
                case 107: trackBar5.Value = e.Message.Data2;
                    label5.Text = e.Message.Data2.ToString();
                    break;
                case 108: trackBar6.Value = e.Message.Data2;
                    label6.Text = e.Message.Data2.ToString();
                    break;
                case 109: trackBar7.Value = e.Message.Data2;
                    label7.Text = e.Message.Data2.ToString();
                    break;
                case 110: trackBar8.Value = e.Message.Data2;
                    label8.Text = e.Message.Data2.ToString();
                    break;
            }

            /*context.Post(delegate(object dummy)
            {
                channelListBox.Items.Add(
                    e.Message.Command.ToString() + '\t' + '\t' +
                    e.Message.MidiChannel.ToString() + '\t' +
                    e.Message.Data1.ToString() + '\t' +
                    e.Message.Data2.ToString());

                channelListBox.SelectedIndex = channelListBox.Items.Count - 1;
            }, null);*/
        }

        private void HandleSysExMessageReceived(object sender, SysExMessageEventArgs e)
        {
           /* context.Post(delegate(object dummy)
            {
                string result = "\n\n"; ;

                int i = 0;

                foreach (byte b in e.Message)
                {
                    
                }

                
            }, null);*/

            label9.Text = "SysEx ist da";
            Byte[] sysBytes = e.Message.GetBytes();
            string fileName = "";
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {

                fileName = saveFileDialog1.FileName;
                FileStream myStream = new FileStream(fileName, FileMode.Create, FileAccess.Write, FileShare.None);
                myStream.Write(sysBytes, 0, e.Message.Length);
                myStream.Close();
            } 
        }

        private void HandleSysCommonMessageReceived(object sender, SysCommonMessageEventArgs e)
        {
            label9.Text = "Hallo";
        }


        private void button1_Click(object sender, EventArgs e)
        {
            outDevice.Send(new ChannelMessage(ChannelCommand.ProgramChange, 0, 3, 3));
            if (InputDevice.DeviceCount > 0) try
            {
                inDevice.StartRecording();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error!", MessageBoxButtons.OK, MessageBoxIcon.Stop);
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 0, 1));  
            if (InputDevice.DeviceCount > 0) try
            {
                inDevice.StopRecording();
                inDevice.Reset();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error!", MessageBoxButtons.OK, MessageBoxIcon.Stop);
            }
            comboBox1.Items.Add("Test");
        }

        private void trackBar1_Scroll(object sender, EventArgs e)
        {
            outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 103, trackBar1.Value)); // 103
            label1.Text = trackBar1.Value.ToString();
        }

        private void trackBar2_Scroll(object sender, EventArgs e)
        {
            outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 104, trackBar2.Value));
            label2.Text = trackBar2.Value.ToString();
        }

        private void trackBar3_Scroll(object sender, EventArgs e)
        {
            outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 105, trackBar3.Value));
            label3.Text = trackBar3.Value.ToString();
        }

        private void trackBar4_Scroll(object sender, EventArgs e)
        {
            outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 106, trackBar4.Value));
            label4.Text = trackBar4.Value.ToString();
        }

        private void trackBar5_Scroll(object sender, EventArgs e)
        {
            outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 107, trackBar5.Value));
            label5.Text = trackBar5.Value.ToString();
        }

        private void trackBar6_Scroll(object sender, EventArgs e)
        {
            outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 108, trackBar6.Value));
            label6.Text = trackBar6.Value.ToString();
        }

        private void trackBar7_Scroll(object sender, EventArgs e)
        {
            outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 109, trackBar7.Value));
            label7.Text = trackBar7.Value.ToString();
        }

        private void trackBar8_Scroll(object sender, EventArgs e)
        {
            outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 110, trackBar8.Value));
            label8.Text = trackBar8.Value.ToString();
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 102, comboBox1.SelectedIndex));
        }

        private void button3_Click(object sender, EventArgs e)
        {
            //byte[] sysexDaten = new byte[]{0xF0, 0x00, 0x20, 0x0D, 0x7F, 0x07, 0x00, 0x07, 0x31, 0x67, 0x00, 0x31, 0x68, 0x00, 0x31, 0x69, 0x00, 0x31, 0x6A, 0x00, 0xF7};
            //outDevice.Send(new SysExMessage(sysexDaten));

            /*for (int i = 1; i <= 10; i++)            
                outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 101 + i, i));
            
            for (int i = 12; i <= 15; i++) 
                outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 101 + i, i)); 
            
            for (int i = 1; i <= 100; i++)              
                outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 112, i));*/
            //zaehler = 1;
            //timer1_Tick(sender, e);
            outDevice.Send(new ChannelMessage(ChannelCommand.NoteOn, 1, 72, 50));
            
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            int x = 0;
            int WarteZeit = 50;
            zaehler = 1;
            for (zaehler = 1; zaehler <= 100; zaehler++)
            {
                //if (zaehler % 10 == 0) x = 15; else x = 0; 
                //if (zaehler > 50) x = 1; else x = 0;
                outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 102, x));
                //for (int i = 2; i <= 10; i++)
                //  outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 101 + i, x));
                Thread.Sleep(WarteZeit); ;
                outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 103, x)); Thread.Sleep(WarteZeit);
                outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 104, 100)); Thread.Sleep(WarteZeit);
                outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 105, x)); Thread.Sleep(WarteZeit);
                outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 106, x)); Thread.Sleep(WarteZeit);
                outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 107, x)); Thread.Sleep(WarteZeit);
                outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 108, x)); Thread.Sleep(WarteZeit);
                outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 109, x)); Thread.Sleep(WarteZeit);
                outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 110, x)); Thread.Sleep(WarteZeit);
                outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 111, x)); Thread.Sleep(WarteZeit);
                for (int i = 12; i <= 15; i++)
                {
                    outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 101 + i, x));
                    Thread.Sleep(WarteZeit);
                }
                Thread.Sleep(WarteZeit);
                outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 113, x));
                Thread.Sleep(WarteZeit);
                outDevice.Send(new ChannelMessage(ChannelCommand.Controller, 0, 112, zaehler));
                Thread.Sleep(WarteZeit);
            }
            zaehler++;
            if (zaehler > 100)
            {
                zaehler = 1;
                timer1.Stop();
            }
        }        
    }
}