Office.initialize = function (reason) {
	Office.context.document.addHandlerAsync(Office.EventType.DocumentSelectionChanged, myHandler);
}

function myHandler(eventArgs) {
	showMessage("");

    Office.context.document.getSelectedDataAsync(Office.CoercionType.Text, function (result) {
        if (result.status == "succeeded")
			document.getElementById("txtAuswahl").value = result.value;
		else
			showMessage(result.error.message);
    });
}

function insertText() {
	showMessage("");

    Office.context.document.setSelectedDataAsync(document.getElementById("txtInsertText").value, function (result) {
        if (result.status == "failed")
            showMessage(result.error.message);
    });
}

function insertMatrix() {
	showMessage("");

	var testArray = [['a', 'b'],['c', 'd'],['e', 'f']];

	Office.context.document.setSelectedDataAsync(testArray, { coercionType: "matrix" }, function (result) {
        if (result.status == "failed")
            showMessage(result.error.message);
    });
}

function getMatrix() {
    Office.context.document.getSelectedDataAsync(Office.CoercionType.Matrix, function (result) {
		if (result.status == "succeeded")
            showMatrix(result.value);
    });
}

function insertImage() {
	showMessage("");

	var imgHTML = "<img src='" + document.getElementById("txtInsertImage").value + "' img/>";
	
    Office.context.document.setSelectedDataAsync(imgHTML, { coercionType: "html" }, function (result) {
        if (result.status == "failed")
            showMessage(result.error.message);
	});
}

function showMessage(message) {
	document.getElementById("txtMessage").value = message;
}

function showMatrix(data) {
	var printOut = "";
	
	for (var y = 0 ; y < data.length; y++) {
		for (var x = 0; x < data[y].length; x++) {
			printOut += data[y][x] + ", ";
		}
	}
	document.getElementById("txtAuswahl").value = printOut;
}
