
//******************* Bitscan **********************
inline int findfirstbsf(ULONGLONG v) {
 assert(v); 
 DWORD index;
 BitScanForward64(&index,v); 
 return index;
}

static const int DeBruijn64 [64] = {
 0,  1,  2, 53,  3,  7, 54, 27,
 4, 38, 41,  8, 34, 55, 48, 28,
62,  5, 39, 46, 44, 42, 22,  9,
24, 35, 59, 56, 49, 18, 29, 11,
63, 52,  6, 26, 37, 40, 33, 47,
61, 45, 43, 21, 23, 58, 17, 10,
51, 25, 36, 32, 60, 20, 57, 16,
50, 31, 19, 15, 30, 14, 13, 12,
};
 
inline int findfirstdebruj64 (ULONGLONG v) {
 assert(v);
 return DeBruijn64[((v&-v)*0x022fdd63cc95386d) >> 58];
}

inline int findfirstfloat (ULONGLONG v) {
 assert(v);
 float d=(float)(v&-v);       
 return (((WORD*) &d)[1]>>7) -0x7f;
}

inline int findfirstpopcnt(ULONGLONG v){
 assert(v); 
 return (int) _mm_popcnt_u64 (~v & (v - 1));
}

//*************** mit tbm, bmi ***************************

inline int findfirstdebruj64_bmi (ULONGLONG v) {
 assert (v);
 return DeBruijn64[(_blsi_u64(v)*0x022fdd63cc95386d) >> 58];
}

inline int findfirstpopcnt_tbm(ULONGLONG v){
 assert (v)
 return (int) _mm_popcnt_u64 (_blsfill_u64(v));
}
