#!/usr/bin/perl
#
# Little script to calculate the time diff 
#
# Copyright (C) 2013 Heise Zeitschriften Verlag GmbH & Co. KG
# Author: Kai Wasserbaech <kaw@heise.de>

use strict;
use warnings;
use utf8;
binmode STDOUT, ":encoding(utf-8)";

use DateTime::Format::Strptime;
use Time::Duration;

sub stripWhiteSpaces {
	my $sStr = shift;
	for($sStr) {
		s/^\s+//;
		s/\s+$//;
	}
	return $sStr;
}


unless(-r $ARGV[0]) {
	die("One input file path expected!");
}

open(my $timestamps, '<', $ARGV[0]) or 
    die(sprintf("Couldn't open %s!",$ARGV[0]));

my ($sFName, $sTime1, $sTime2, $oTime1, $oTime2, 
    $diff,  $sdiff);

my @aTmp;
my $strp1 = DateTime::Format::Strptime->new(
	pattern => '%Y%m%d-%H%M',
	time_zone => 'Europe/Berlin',
	on_error => 'croak'
);
my $strp2 = DateTime::Format::Strptime->new(
	pattern => '%Y %b %d %H:%M',
	locale => 'en_US',
	time_zone => 'Europe/Berlin',
	on_error => 'croak'
);


while(<$timestamps>) {
	@aTmp = split /\|/;

	$sFName = $aTmp[0];
	next  if($sFName =~ m/^\s+$/); # leere Zeilen

	$sTime1 = $aTmp[1];
	$sTime1 = stripWhiteSpaces($sTime1);
	$oTime1 = $strp1->parse_datetime($sTime1);

	$sTime2 = $aTmp[2];
	$sTime2 = stripWhiteSpaces($sTime2);
	$oTime2 = $strp2->parse_datetime('2012 '.$sTime2);

	$diff = $oTime2->strftime('%s') - $oTime1->strftime('%s');
	$sdiff = later($diff);

	printf("%s %s \t%ds\t%s\n",
	       $sFName, 
	       $oTime1,
	       $diff,
	       $sdiff);
}
close $timestamps;
