/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class knucleotide {
    static ArrayList<Callable<Map<ByteString, ByteString>>> createFragmentTasks(final byte[] byArray, int[] nArray) {
        ArrayList<Callable<Map<ByteString, ByteString>>> arrayList = new ArrayList<Callable<Map<ByteString, ByteString>>>();
        for (int n : nArray) {
            int n2 = 0;
            while (n2 < n) {
                final int n3 = n2++;
                final int n4 = n;
                arrayList.add(new Callable<Map<ByteString, ByteString>>(){

                    @Override
                    public Map<ByteString, ByteString> call() {
                        return knucleotide.createFragmentMap(byArray, n3, n4);
                    }
                });
            }
        }
        return arrayList;
    }

    static Map<ByteString, ByteString> createFragmentMap(byte[] byArray, int n, int n2) {
        HashMap<ByteString, ByteString> hashMap = new HashMap<ByteString, ByteString>();
        int n3 = byArray.length - n2 + 1;
        ByteString byteString = new ByteString(n2);
        for (int i = n; i < n3; i += n2) {
            byteString.calculateHash(byArray, i);
            ByteString byteString2 = hashMap.get(byteString);
            if (byteString2 != null) {
                ++byteString2.count;
                continue;
            }
            hashMap.put(byteString, byteString);
            byteString = new ByteString(n2);
        }
        return hashMap;
    }

    static Map<ByteString, ByteString> sumTwoMaps(Map<ByteString, ByteString> map, Map<ByteString, ByteString> map2) {
        for (Map.Entry<ByteString, ByteString> entry : map2.entrySet()) {
            ByteString byteString = map.get(entry.getKey());
            if (byteString != null) {
                byteString.count += entry.getValue().count;
                continue;
            }
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    static String writeFrequencies(float f, Map<ByteString, ByteString> map) {
        TreeSet<ByteString> treeSet = new TreeSet<ByteString>(map.values());
        StringBuilder stringBuilder = new StringBuilder();
        for (ByteString byteString : treeSet) {
            stringBuilder.append(String.format("%s %.3f\n", byteString.toString().toUpperCase(), Float.valueOf((float)byteString.count * 100.0f / f)));
        }
        return stringBuilder.append('\n').toString();
    }

    static String writeCount(List<Future<Map<ByteString, ByteString>>> list, String string) throws Exception {
        ByteString byteString = new ByteString(string.length());
        byteString.calculateHash(string.getBytes(), 0);
        int n = 0;
        for (Future<Map<ByteString, ByteString>> future : list) {
            ByteString byteString2 = future.get().get(byteString);
            if (byteString2 == null) continue;
            n += byteString2.count;
        }
        return n + "\t" + string.toUpperCase() + '\n';
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        System.out.println("Starte WarmUp ...");
        for (int i = 0; i < 10000000; ++i) {
            double d = Math.random() / Math.random();
        }
        System.out.print("Beende WarmUp ...");
        long l2 = System.currentTimeMillis();
        System.out.println("Gesamtzeit: " + (l2 - l) + " ms");
        long l3 = System.currentTimeMillis();
        knucleotide.benchmark(stringArray);
        long l4 = System.currentTimeMillis();
        System.out.println("Gesamtzeit: " + (l4 - l3) + " ms");
    }

    public static void warmUp(String[] stringArray) throws Exception {
        for (int i = 0; i < 10; ++i) {
            int n = i;
            knucleotide.benchmark(stringArray);
            if (i != 9) {
                System.out.print(++n + ", ");
                continue;
            }
            System.out.println(++n + ";");
        }
    }

    public static void benchmark(String[] stringArray) throws Exception {
        String[] stringArray2;
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while ((string = bufferedReader.readLine()) != null && !string.startsWith(">THREE")) {
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[100];
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            if (string.length() > byArray.length) {
                byArray = new byte[string.length()];
            }
            for (n = 0; n < string.length(); ++n) {
                byArray[n] = (byte)string.charAt(n);
            }
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        int[] nArray = new int[]{1, 2, 3, 4, 6, 12, 18};
        List<Future<Map<ByteString, ByteString>>> list = executorService.invokeAll(knucleotide.createFragmentTasks(byArray2, nArray));
        executorService.shutdown();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(knucleotide.writeFrequencies(byArray2.length, list.get(0).get()));
        stringBuilder.append(knucleotide.writeFrequencies(byArray2.length - 1, knucleotide.sumTwoMaps(list.get(1).get(), list.get(2).get())));
        for (String string2 : stringArray2 = new String[]{"ggt", "ggta", "ggtatt", "ggtattttaatt", "ggtattttaatttatagt"}) {
            stringBuilder.append(knucleotide.writeCount(list, string2));
        }
        String string3 = stringBuilder.toString();
        Object var11_14 = null;
    }

    static final class ByteString
    implements Comparable<ByteString> {
        public int hash;
        public int count = 1;
        public final byte[] bytes;

        public ByteString(int n) {
            this.bytes = new byte[n];
        }

        public void calculateHash(byte[] byArray, int n) {
            int n2 = 0;
            for (int i = 0; i < this.bytes.length; ++i) {
                byte by;
                this.bytes[i] = by = byArray[n + i];
                n2 = n2 * 31 + by;
            }
            this.hash = n2;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            return Arrays.equals(this.bytes, ((ByteString)object).bytes);
        }

        @Override
        public int compareTo(ByteString byteString) {
            if (byteString.count != this.count) {
                return byteString.count - this.count;
            }
            return this.toString().compareTo(byteString.toString());
        }

        public String toString() {
            return new String(this.bytes);
        }
    }
}

