/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.OutputStream;

public class fastaredux {
    static final int LINE_LENGTH = 60;
    static final int OUT_BUFFER_SIZE = 262144;
    static final int LOOKUP_SIZE = 4096;
    static final double LOOKUP_SCALE = 4095.0;
    static final String ALU = "GGCCGGGCGCGGTGGCTCACGCCTGTAATCCCAGCACTTTGGGAGGCCGAGGCGGGCGGATCACCTGAGGTCAGGAGTTCGAGACCAGCCTGGCCAACATGGTGAAACCCCGTCTCTACTAAAAATACAAAAATTAGCCGGGCGTGGTGGCGCGCGCCTGTAATCCCAGCTACTCGGGAGGCTGAGGCAGGAGAATCGCTTGAACCCGGGAGGCGGAGGTTGCAGTGAGCCGAGATCGCGCCACTGCACTCCAGCCTGGGCGACAGAGCGAGACTCCGTCTCAAAAA";
    static final Freq[] IUB = new Freq[]{new Freq('a', 0.27), new Freq('c', 0.12), new Freq('g', 0.12), new Freq('t', 0.27), new Freq('B', 0.02), new Freq('D', 0.02), new Freq('H', 0.02), new Freq('K', 0.02), new Freq('M', 0.02), new Freq('N', 0.02), new Freq('R', 0.02), new Freq('S', 0.02), new Freq('V', 0.02), new Freq('W', 0.02), new Freq('Y', 0.02)};
    static final Freq[] HomoSapiens = new Freq[]{new Freq('a', 0.302954942668), new Freq('c', 0.1979883004921), new Freq('g', 0.1975473066391), new Freq('t', 0.3015094502008)};

    static void sumAndScale(Freq[] freqArray) {
        double d = 0.0;
        for (int i = 0; i < freqArray.length; ++i) {
            freqArray[i].p = (d += freqArray[i].p) * 4095.0;
        }
        freqArray[freqArray.length - 1].p = 4095.0;
    }

    public static void main(String[] stringArray) throws IOException {
        long l = System.currentTimeMillis();
        int n = 25000000;
        if (stringArray.length > 0) {
            n = Integer.parseInt(stringArray[0]);
        }
        fastaredux.sumAndScale(IUB);
        fastaredux.sumAndScale(HomoSapiens);
        Out.stream = System.out;
        RepeatFasta.make(">ONE Homo sapiens alu\n", ALU.getBytes(), n * 2);
        RandomFasta.make(">TWO IUB ambiguity codes\n", IUB, n * 3);
        RandomFasta.make(">THREE Homo sapiens frequency\n", HomoSapiens, n * 5);
        long l2 = System.currentTimeMillis();
        System.out.println("Gesamtzeit: " + (l2 - l) + " ms");
        Out.close();
    }

    static final class RepeatFasta {
        RepeatFasta() {
        }

        static void make(String string, byte[] byArray, int n) throws IOException {
            int n2;
            System.arraycopy(string.getBytes(), 0, Out.buf, Out.ct, string.length());
            Out.ct += string.length();
            byte[] byArray2 = new byte[byArray.length + 60];
            for (n2 = 0; n2 < byArray2.length; n2 += byArray.length) {
                System.arraycopy(byArray, 0, byArray2, n2, Math.min(byArray.length, byArray2.length - n2));
            }
            n2 = 0;
            while (n > 0) {
                int n3 = Math.min(60, n);
                Out.checkFlush();
                System.arraycopy(byArray2, n2, Out.buf, Out.ct, n3);
                Out.ct += n3;
                Out.buf[Out.ct++] = 10;
                n2 = (n2 + n3) % byArray.length;
                n -= n3;
            }
        }
    }

    static final class RandomFasta {
        static final Freq[] lookup = new Freq[4096];

        RandomFasta() {
        }

        static void makeLookup(Freq[] freqArray) {
            int n = 0;
            for (int i = 0; i < 4096; ++i) {
                while (freqArray[n].p < (double)i) {
                    ++n;
                }
                RandomFasta.lookup[i] = freqArray[n];
            }
        }

        static void addLine(int n) throws IOException {
            Out.checkFlush();
            int n2 = Out.ct;
            while (n2 < Out.ct + n) {
                double d = Random.next();
                int n3 = (int)d;
                while (RandomFasta.lookup[n3].p < d) {
                    ++n3;
                }
                Out.buf[n2++] = RandomFasta.lookup[n3].c;
            }
            Out.buf[n2++] = 10;
            Out.ct = n2;
        }

        static void make(String string, Freq[] freqArray, int n) throws IOException {
            RandomFasta.makeLookup(freqArray);
            System.arraycopy(string.getBytes(), 0, Out.buf, Out.ct, string.length());
            Out.ct += string.length();
            while (n > 0) {
                int n2 = Math.min(60, n);
                RandomFasta.addLine(n2);
                n -= n2;
            }
        }
    }

    static final class Out {
        static final byte[] buf = new byte[262144];
        static final int lim = 262023;
        static int ct = 0;
        static OutputStream stream;

        Out() {
        }

        static void checkFlush() throws IOException {
            if (ct >= 262023) {
                stream.write(buf, 0, ct);
                ct = 0;
            }
        }

        static void close() throws IOException {
            stream.write(buf, 0, ct);
            ct = 0;
            stream.close();
        }
    }

    static final class Random {
        static final int IM = 139968;
        static final int IA = 3877;
        static final int IC = 29573;
        static final double SCALE = 0.029256687242798354;
        static int last = 42;

        Random() {
        }

        static double next() {
            last = (last * 3877 + 29573) % 139968;
            return 0.029256687242798354 * (double)last;
        }
    }

    static final class Freq {
        byte c;
        double p;

        Freq(char c, double d) {
            this.c = (byte)c;
            this.p = d;
        }
    }
}

