library(shiny)
library(datasets)
library(ggplot2)
Rosemary <-read.csv('Rosemary.csv', header=FALSE)
Bella <-read.csv('Bella.csv', header=FALSE)
RoseBella <- data.frame(Time = seq(1880, 2011), Bella$V1, Rosemary$V1)

shinyServer(function(input, output) {

  output$Rosemary <- renderPlot({
    p<-ggplot(RoseBella, aes(x=Time)) + geom_line(aes(y = Rosemary.V1, colour = "Rosemary")) 
    if(input$movie){p <- p + geom_vline(xintercept=1918,col="green") + geom_vline(xintercept=1915,col="green") }
    print(p) 
  })
  
  output$Bella <- renderPlot({
    p<-ggplot(RoseBella, aes(x=Time)) + geom_line(aes(y = Bella.V1, col= "Bella"))
    if(input$movie){p <- p + geom_vline(xintercept=2008, col="blue") + geom_vline(xintercept=2005, col="blue") }
    print(p) 
  })
  
  output$Rosemaryandbella <- renderPlot({
    p<-ggplot(RoseBella, aes(x=Time)) + geom_line(aes(y = Rosemary.V1, colour = "Rosemary")) + geom_line(aes(y = Bella.V1, colour = "Bella"))
    if(input$movie){p <- p + geom_vline(xintercept=2008, col="blue") + geom_vline(xintercept=2005, col="blue") + geom_vline(xintercept=1918,col="green") + geom_vline(xintercept=1915,col="green")}
    print(p) 
    })
})
