﻿// Eine Einführung zur Seitensteuerelementvorlage finden Sie in der folgenden Dokumentation:
// http://go.microsoft.com/fwlink/?LinkId=232511
(function () {
    "use strict";

    var detailsPage = WinJS.UI.Pages.define("/pages/details/details.html", {
        // Diese Funktion wird immer aufgerufen, wenn ein Benutzer zu dieser Seite wechselt. Sie
        // füllt die Seitenelemente mit den Daten der App auf.
        ready: function (element, options) {
            // TODO: Die Seite hier initialisieren.
            var that = this;
            that.theElement = options;
            var page = that.element;
            var header = page.getElementsByClassName('pagetitle');
            header[0].textContent = that.theElement.name;

            // ****************************************************************************
            // ** Hier bitte vor dem Start die eigene AppID von Wolfram Alpha einsetzen. **
            // ****************************************************************************
            var appId = 'XXXXXX-XXXXXXXXXX';

            // Get details from Wolfram Alpha
            WinJS.xhr({
                // Siehe http://products.wolframalpha.com/api/
                url: 'http://api.wolframalpha.com/v2/query?input=' + that.theElement.engName + '&appid=' + appId,
                responseType: document
            }).then(
                that.downloadCompleted,
                function (err) {
                    showError(err.message);
                }
            );
        },

        downloadCompleted: function (request) {
            try {
                var imgFrame = document.getElementById("images");
                if (!imgFrame) {
                    // The user might have navigated away from this page
                    // while download was in progress. Discard the result.
                    return;
                }
                if (request.status != 200) {
                    showError("HTTP-Status " + request.status);
                    return;
                }
                var xml = request.responseXML;
                var result = xml.getElementsByTagName("queryresult");
                if (result) {
                    result = result[0];
                }
                else {
                    showError("Kein Result-Tag gefunden.");
                    return;
                }
                if (!result.attributes["success"] || result.attributes["success"].value != "true" || !result.attributes["error"] || result.attributes["error"].value != "false") {
                    var msg = "Fehler im Result-Tag.";
                    var err = result.getElementsByTagName("error");
                    if (err) {
                        err = err[0];
                        var message = err.getElementsByTagName("msg");
                        if (message) {
                            message = message[0];
                            msg = "Wolfram Alpha meldet: " + message.textContent;
                        }
                    }
                    showError(msg);
                    return;
                }
                if (result.attributes["timedout"] && result.attributes["timedout"].value) {
                    var recalcUrl = result.attributes["recalculate"].value;
                    WinJS.xhr({
                        url: recalcUrl,
                        responseType: document
                    }).done(
                        detailsPage.prototype.downloadCompleted,
                        function (err) {
                            showError(err.message);
                        }
                    );
                }
                var pods = result.getElementsByTagName("pod");
                for (var p = 0; p < pods.length; p++) {
                    var pod = pods[p];
                    var podID = pod.attributes["id"].value;
                    if (podID != "Input" && podID != "PeriodicTableLocation:ElementData") {
                        var subPods = pod.getElementsByTagName("subpod");
                        for (var sp = 0; sp < subPods.length; sp++) {
                            var subPod = subPods[sp];
                            var imgs = subPod.getElementsByTagName("img");
                            for (var i = 0; i < imgs.length; i++) {
                                var img = imgs[i];
                                var imgTag = document.createElement("img");
                                for (var a = 0; a < img.attributes.length; a++) {
                                    var att = img.attributes[a];
                                    imgTag.setAttribute(att.name, att.value);
                                }
                                imgFrame.appendChild(imgTag);
                            };
                        };
                    }
                };
            }
            finally {
                var progress = document.getElementById("please_wait");
                if (progress) {
                    progress.style.visibility = 'collapse';
                }
            }
        },

        unload: function () {
            // TODO: Auf Navigationen weg von dieser Seite reagieren.
        },

        updateLayout: function (element) {
            /// <param name="element" domElement="true" />

            // TODO: Auf Änderungen im Layout reagieren.
        }
    });

    var showError = function (msg) {
        (new Windows.UI.Popups.MessageDialog(msg, "Fehler")).showAsync();
    };

})();
