﻿using UnityEngine;
using System.Collections;

public class Ballonwerfer : MonoBehaviour
{

  public GameObject[] balloons;
  public float minTimeBetweenThrows = 2f;
  public float maxTimeBetweenThrows = 7f;

  private float minX, maxX;
  
  // Use this for initialization
  void Start()
  {
    float margin = balloons[0].renderer.bounds.size.x;
    minX = GameObject.Find("WandLinks").transform.position.x + margin;
    maxX = GameObject.Find("WandRechts").transform.position.x - margin;
    StartCoroutine(ThrowBalloons());
  }
  
  IEnumerator ThrowBalloons()
  {
    while(true) {
      // Einen Ballon zufällig auswählen, positionieren und werfen
      int balloonIndex = Random.Range(0, balloons.Length);
      float xPos = Random.Range(minX, maxX);
      Vector3 pos = new Vector3(xPos, transform.position.y, transform.position.z);
      Instantiate(balloons[balloonIndex], pos, transform.rotation);
      // Vor dem nächsten Ballon ein paar Sekunden warten
      float waitTime = Random.Range(minTimeBetweenThrows, maxTimeBetweenThrows);
      yield return new WaitForSeconds(waitTime);
    }
  }
}
