﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Microsoft.Kinect;

namespace KinectHandTest
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private KinectSensor kinectSensor = null;
        private BodyFrameReader bodyFrameReader = null;
        private Body[] bodies = null;


        private void Form1_Load(object sender, EventArgs e)
        {
            kinectSensor = KinectSensor.GetDefault();
            kinectSensor.Open();
            bodyFrameReader = kinectSensor.BodyFrameSource.OpenReader();
            if (this.bodyFrameReader != null)
            {
                this.bodyFrameReader.FrameArrived += this.Reader_FrameArrived;
            }
            serialPort1.Open();
        }

        private void Reader_FrameArrived(object sender, BodyFrameArrivedEventArgs e)
        {
            bool dataReceived = false;
            int count = 0;           
            using (BodyFrame bodyFrame = e.FrameReference.AcquireFrame())
            {
                panel1.BackColor = Color.FromArgb(255, 0, 0, 0);
                if (bodyFrame != null)
                {
                    if (this.bodies == null)
                    {
                        this.bodies = new Body[bodyFrame.BodyCount];
                    }

                    // The first time GetAndRefreshBodyData is called, Kinect will allocate each Body in the array.
                    // As long as those body objects are not disposed and not set to null in the array,
                    // those body objects will be re-used.
                    
                    //count = bodyFrame.BodyCount;
                    //label1.Text = count.ToString();
                    bodyFrame.GetAndRefreshBodyData(this.bodies);
                    dataReceived = true;
                }
            }

            if (dataReceived)
            {

                foreach (Body body in this.bodies)
                //Body body = bodies[0];
                if (body.IsTracked)
                {
                    panel1.BackColor = Color.FromArgb(255, 0, 0, 255);
                    if (body.HandLeftState == HandState.Closed) panel1.BackColor = Color.FromArgb(255, 255, 0, 0);
                    if (body.HandLeftState == HandState.Lasso) panel1.BackColor = Color.FromArgb(255, 0, 255, 0);
                    if (body.HandLeftState == HandState.Open) panel1.BackColor = Color.FromArgb(255, 0, 255, 255);
                    if (body.HandLeftState == HandState.Unknown) panel1.BackColor = Color.FromArgb(255, 255, 255, 0);
                    if (body.HandLeftState == HandState.NotTracked) panel1.BackColor = Color.FromArgb(255, 255, 0, 255);
                    /*label1.Text = body.TrackingId.ToString();
                    foreach (KeyValuePair<Activity, DetectionResult> activity in body.Activities)
                        if (activity.Key == Activity.EyeLeftClosed)
                            if (activity.Value == DetectionResult.Unknown)
                            panel2.BackColor = Color.FromArgb(255, 255, 0, 0);
                        else panel2.BackColor = Color.FromArgb(255, 255, 255, 255); */
                    Joint joint = body.Joints[JointType.HandTipLeft]; 
                    if (joint.TrackingState == TrackingState.Tracked) {                        
                        int x = Convert.ToInt32((joint.Position.X * 100 + 100)/3.3);                        
                        int y = Convert.ToInt32(joint.Position.Y * 100 + 100);
                        int z = Convert.ToInt32(joint.Position.Z * 100 + 100);
                        label1.Text = x.ToString();
                        byte[] byteBuf = {0, 0, 0};
                        if (x > 59) x = 59; if (x < 0) x = 0;
                        byte byteX = Convert.ToByte(x);
                        byteBuf[0] = byteX; //if (z < 150 && z > 50) byteBuf[0] = 45; else byteBuf[0] = 25;
                        if (serialPort1.IsOpen) serialPort1.Write(byteBuf, 0, 3); else label1.Text = "Com nicht offen";                        
                    } else label1.Text = "Nicht erkannt!";

                }
                count += 1;
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (this.bodyFrameReader != null)
            {
                // BodyFrameReader is IDisposable
                this.bodyFrameReader.Dispose();
                this.bodyFrameReader = null;
            }

            if (this.kinectSensor != null)
            {
                this.kinectSensor.Close();
                this.kinectSensor = null;
            }
            if (serialPort1.IsOpen) serialPort1.Close();
        }
    }
}
