package com.linkesoft.ctlongitude;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender.SendIntentException;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.location.Address;
import android.location.Location;
import android.net.Uri;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.Base64;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Toast;

import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.GoogleApiClient.ConnectionCallbacks;
import com.google.android.gms.common.api.GoogleApiClient.OnConnectionFailedListener;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.MapFragment;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.plus.Plus;
import com.google.android.gms.plus.PlusClient.OnAccessRevokedListener;
import com.google.android.gms.plus.model.people.Person;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.Node;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.PutDataMapRequest;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.Wearable;
import com.linkesoft.ctlongitude.common.Friend;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class MainActivity extends Activity implements ConnectionCallbacks, OnConnectionFailedListener, OnAccessRevokedListener {

	//static final String CLIENT_ID = "794079768346.apps.googleusercontent.com";// debug
	static final String CLIENT_ID = "959761978819-355qnb4u11nqs56nre69buihpnqe3h1v.apps.googleusercontent.com"; // release
	static final String OAUTH_CLIENT_SCOPE = "audience:server:client_id:" + CLIENT_ID;
    static final String WEB_URL = "http://ersatzworld.net/ct/ctlon/";
    //static final String WEB_URL = "";
	static final String FRIENDS_URL = WEB_URL + "ajax/friends.php";
	static final String POSITION_URL = WEB_URL + "ajax/setloc.php";

	protected static final int REQUEST_CODE_SIGN_IN = 0;

	private static final int FRIENDS_MENU_ID = Menu.FIRST;
	private static final String USERID = "userId";
	private static final String ACCOUNTNAME = "accountName";
	private static final String SENDLOCATIONUPDATES = "sendLocationUpdates";
	private GoogleApiClient googleApiClient;
	private ConnectionResult connectionResult;
	private GoogleMap map;
	private Address currentAddress;

	private final List<Friend> friends = new ArrayList<Friend>();

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		googleApiClient = new GoogleApiClient.Builder(this, this, this).addApi(Plus.API).addApi(Wearable.API).addScope(Plus.SCOPE_PLUS_LOGIN).build();

		map = ((MapFragment) getFragmentManager().findFragmentById(R.id.map)).getMap();
        if(map==null) {
            Log.e(getClass().getSimpleName(),"Google Map control not found");
            return;
        }
		map.setMyLocationEnabled(true); // zeige eigenen Ort

		findViewById(R.id.sign_in_button).setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				if (!googleApiClient.isConnected() && connectionResult != null)
					try {
						connectionResult.startResolutionForResult(MainActivity.this, REQUEST_CODE_SIGN_IN);
					} catch (SendIntentException e) {
						Log.e(getClass().getSimpleName(), "Connection resolution interrupted", e);
				}
			}
		});

	}

	@Override
	protected void onStart() {
		super.onStart();
		if (GooglePlayServicesUtil.isGooglePlayServicesAvailable(this) != ConnectionResult.SUCCESS)
			Toast.makeText(this, "This app requires an Android device with Google Play services", Toast.LENGTH_LONG)
					.show();
		else
			googleApiClient.connect(); // asynchron, ruft entweder onConnected oder onConnectionFailed
	}

	@Override
	protected void onStop() {
		super.onStop();
		googleApiClient.disconnect(); // asynchron
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	@Override
	public boolean onPrepareOptionsMenu(Menu menu) {
		fillFriendsMenu(menu.findItem(R.id.friendsSubMenu).getSubMenu());
		menu.findItem(R.id.sendLocationUpdates).setChecked(getSendLocationUpdates(this));
		return super.onPrepareOptionsMenu(menu);
	}
	
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		case R.id.refresh:
			getFriends();
			return true;
		case R.id.openInWeb:
			openBrowser();
			return true;
		case R.id.disconnect:
			signOut();
			return true;
		case R.id.sendLocationUpdates:
			toggleLocationUpdates();
			return true;
		}

		// kein Standard-Menü-Eintrag
		if (item.getItemId() >= FRIENDS_MENU_ID && item.getItemId() - FRIENDS_MENU_ID < friends.size()) {
			Friend friend = friends.get(item.getItemId() - FRIENDS_MENU_ID);
			// center on map
			centerMapOnFriend(friend);
			showMarkerInfoForFriend(friend);
			return true;
		}
		return super.onOptionsItemSelected(item);
	}

	private void fillFriendsMenu(SubMenu subMenu) {
		int ind = 0;
		subMenu.clear();
		for (Friend friend : friends) {
			subMenu.add(Menu.NONE, FRIENDS_MENU_ID + ind, Menu.NONE, friend.name);
			ind++;
		}

	}
	// Ausloggen
	private void signOut() {
		if(googleApiClient.isConnected()) {
			Plus.AccountApi.clearDefaultAccount(googleApiClient);
			Plus.AccountApi.revokeAccessAndDisconnect(googleApiClient).setResultCallback(new ResultCallback<Status>() {
				@Override
				public void onResult(Status result) {
					findViewById(R.id.sign_in_button).setVisibility(View.VISIBLE);
					Toast.makeText(MainActivity.this, "Logged out", Toast.LENGTH_SHORT).show();
					// beende Activity
					finish();
				}
			});
		}
	}
	private void centerMapOnFriend(Friend friend) {
		CameraPosition center = new CameraPosition.Builder().target(new LatLng(friend.location.getLatitude(),friend.location.getLongitude())).zoom(15).build();
		map.animateCamera(CameraUpdateFactory.newCameraPosition(center));		
	}

	private void showAllFriendsOnMap() {
		if(friends.size()==0)
		{
			Log.v(getClass().getSimpleName(),"no friends to show");
			return;
		}
		LatLngBounds.Builder builder = new LatLngBounds.Builder();
		for (Friend friend : friends) {
			builder.include(new LatLng(friend.location.getLatitude(),friend.location.getLongitude()));
		}
		LatLngBounds bounds = builder.build();
		int border = (int) (40 * getResources().getDisplayMetrics().density);
		// add some space so pins can be shown
		map.animateCamera(CameraUpdateFactory.newLatLngBounds(bounds, border)); 	
		}

	

	private void toggleLocationUpdates() {
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(this);
		SharedPreferences.Editor prefsEditor = prefs.edit();
		boolean sendUpdates=!getSendLocationUpdates(this);
		prefsEditor.putBoolean(SENDLOCATIONUPDATES, sendUpdates);
		prefsEditor.commit();
		if(sendUpdates)
			LocationReceiver.startPositionUpdates(this);
		else
			LocationReceiver.stopPositionUpdates(this);
	}



	private void showMarkerInfoForFriend(Friend friend) {
		if (friend.marker != null)
            ((Marker)friend.marker).showInfoWindow();
	}

	private void openBrowser() {
		startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(WEB_URL)));
	}
	// Callback-Methoden

	@Override
	public void onConnected(Bundle connectionHint) {
        // ab hier kann der Google Client verwendet werden
		Log.v(getClass().getSimpleName(), "onConnected");
		// Log-In-Button ausblenden
		findViewById(R.id.sign_in_button).setVisibility(View.GONE);
		String accountName=Plus.AccountApi.getAccountName(googleApiClient);
		Toast.makeText(this, accountName + " is connected.", Toast.LENGTH_LONG).show();
		// store accountName and id for later use
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(this);
		SharedPreferences.Editor prefsEditor = prefs.edit();
		prefsEditor.putString(ACCOUNTNAME, accountName);
		Person user = Plus.PeopleApi.getCurrentPerson(googleApiClient);
        if(user!=null)
		    prefsEditor.putString(USERID, user.getId());
		prefsEditor.commit();
		
		getFriends();
		if(getSendLocationUpdates(this))
			LocationReceiver.startPositionUpdates(this);
	}

	@Override
	public void onConnectionSuspended(int cause) {
		Log.v(getClass().getSimpleName(), "onConnectionSuspended");
	}

	@Override
	public void onConnectionFailed(ConnectionResult result) {
		Log.v(getClass().getSimpleName(), "onConnectionFailed " + result);
		// speichere ConnectionResult für spätere Verwendung
		connectionResult = result;
		findViewById(R.id.sign_in_button).setVisibility(View.VISIBLE);
	}
	

	@Override
	protected void onActivityResult(int requestCode, int responseCode, Intent intent) {
	
		if (requestCode == REQUEST_CODE_SIGN_IN && responseCode == RESULT_OK) {
			googleApiClient.connect(); // starte OAuth-Authentifizierung, asynchron
		} else
			super.onActivityResult(requestCode, responseCode, intent);
	}

	@Override
	public void onAccessRevoked(ConnectionResult arg0) {
		Log.v(getClass().getSimpleName(),"access revoked, logged out");
		Toast.makeText(this, getAccountName(this)+ " logged out.", Toast.LENGTH_LONG).show();
		findViewById(R.id.sign_in_button).setVisibility(View.VISIBLE);		
	}


	private void getFriends() {
        if(WEB_URL.length()!=0) {
            GetFriendsTask friendsTask = new GetFriendsTask(this, gotFriendsListener);
            friendsTask.execute();
        }
        else
            getDemoData();
	}

    private void sendToWearable()
    {
        // TODO handle deleted items
        for(Friend friend:friends)
        {
            Log.v(getClass().getSimpleName(),"Sending friend data to wearable: "+friend.name);
            PutDataMapRequest dataMapRequest = PutDataMapRequest.create("/friend/"+friend.userid);
            DataMap dataMap= dataMapRequest.getDataMap();
            dataMap.putAll(DataMap.fromBundle(friend.toBundle()));
            PutDataRequest request = dataMapRequest.asPutDataRequest();
            Wearable.DataApi.putDataItem(googleApiClient, request).setResultCallback(new ResultCallback<DataApi.DataItemResult>() {
                @Override
                public void onResult(DataApi.DataItemResult dataItemResult) {
                    if (!dataItemResult.getStatus().isSuccess()) {
                        Log.e(getClass().getSimpleName(), "ERROR: failed to putDataItem, status code: "
                                + dataItemResult.getStatus().getStatusCode());
                    }
                    else
                        Log.v(getClass().getSimpleName(), "Sent data item to wearable");
                }
            });
        }
    }

    private void getDemoData() {
        Toast.makeText(this,"No server specified, using demo data.",Toast.LENGTH_LONG).show();
        List<Friend> demo=new ArrayList<Friend>();
        Friend heise=new Friend();
        heise.location =new Location("");
        heise.userid="heise";
        heise.location.setLatitude(52.3805309);
        heise.location.setLongitude(9.7917268);
        heise.name="heise Verlag";
        heise.address=new Address(Locale.getDefault());
        heise.address.setCountryName("Deutschland");
        heise.address.setLocality("Hannover");
        heise.address.setThoroughfare("Karl-Wiechert-Allee 10");
        heise.timestamp=new Date();
        heise.imageuri=imageDataUri(R.drawable.heise);
        demo.add(heise);
        Friend google=new Friend();
        google.userid="google";
        google.location =new Location("");
        google.location.setLatitude(37.4220367);
        google.location.setLongitude(-122.0840278);
        google.name="Google";
        google.address=new Address(Locale.getDefault());
        google.address.setCountryName("USA");
        google.address.setLocality("Mountain View");
        google.address.setThoroughfare("1600 Amphitheatre Pkwy");
        google.timestamp=new Date();
        google.imageuri=imageDataUri(R.drawable.google);
        demo.add(google);

        gotFriendsListener.gotFriends(demo, null);
    }

    private Uri imageDataUri(int resid)
    {
        BitmapDrawable drawable=(BitmapDrawable)getResources().getDrawable(resid);
        ByteArrayOutputStream bytestr=new ByteArrayOutputStream();
        drawable.getBitmap().compress(Bitmap.CompressFormat.JPEG,80,bytestr);
        String base64str= Base64.encodeToString(bytestr.toByteArray(), 0);
        assert base64str.length()<100000; // DataItem API currently limits item size to 100 KB
        return Uri.parse("data:image/png;base64,"+base64str);
    }

    private final GotFriendsListener gotFriendsListener=new GotFriendsListener() {
        @Override
        public void gotFriends(List<Friend> gotfriends, Address ownAddress) {
            currentAddress=ownAddress;
            friends.clear();
            friends.addAll(gotfriends);
            invalidateOptionsMenu();
            // put pins on map
            map.clear();
            for (Friend friend : friends) {
                MarkerOptions marker = new MarkerOptions();
                marker.position(new LatLng(friend.location.getLatitude(), friend.location.getLongitude()));
                marker.title(friend.name + " (" + friend.getFormattedDate() + ")");
                if(friend.address!=null)
                    marker.snippet(friend.getFormattedAddress(currentAddress)); // Untertitel
                friend.marker = map.addMarker(marker); // speichere Marker, um ihn später anzeigen zu können
            }
            showAllFriendsOnMap();
            sendToWearable();
        }
    };

	public static String getAccountUserId(Context ctx)
	{
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(ctx);
		return prefs.getString(USERID, "");
	}
	public static String getAccountName(Context ctx)
	{
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(ctx);
		return prefs.getString(ACCOUNTNAME, "");		
	}

	public static boolean getSendLocationUpdates(Context ctx)
	{
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(ctx);
		return prefs.getBoolean(SENDLOCATIONUPDATES, true);		
	}

    // callback für GetFriendsTask
    public static interface GotFriendsListener {
        void gotFriends(List<Friend> friends, Address ownAddress);
    }
}
