// ponder0914.cpp : Definiert den Einstiegspunkt fr die Konsolenanwendung.
//
/*
ln(x) = sum_k=0^inf (2 / (2k+1)* ((1-x)/(1+x))^(2k+1)
ln(2) = sum k=0^inf (2/(2k+1)* (1/3) ^ (2k+1)= 2*(1/1/3^1+ 1/3/3^3+ 1/5/3^5 + ...
3^1024 *ln(2)= 2*(3^1023/1 + 3^1021/3+3^1019/5+3^1017/7+...

1.53137715531012716440
*/
#include <stdio.h>
#include <math.h>
#include <float.h>
#include <limits.h>
#include <fenv.h>

enum method { nix, frac, kahan };

#define METHOD nix
//#define USE_RC


#ifdef _WIN32
#pragma fenv_access (on)
#define roundup()  _controlfp(_RC_UP, _MCW_RC);
#define rounddown()  _controlfp(_RC_DOWN, _MCW_RC);
#define roundnearest()  _controlfp(_RC_NEAREST, _MCW_RC);
#endif 

#ifdef __linux__
#pragma STDC FENV_ACCESS ON
#define roundup()  fesetround(FE_UPWARD);
#define rounddown()  fesetround(FE_DOWNWARD);
#define roundnearest() fesetround(FE_NEAREST);
#endif 


double frac_3_to_m_div_a(int m, int a) {
	int res = 1;
	if (m >= 0) {
		for (int i = 0; i < m; i++)  {
			res *= 3;
			res %= a;
		}
		return (double)res / a;
	}
	else
		return pow(3.0, m) / a;
}


double calc_kahan(int r)
{
	double f;
	double sum = 0.0;
	double kahan = 0.0;
	double y;
	double t;

	for (int k = 0; k < 512 + r; k++) {
		int n = 2 * k + 1;
		f = frac_3_to_m_div_a(1024 - n, n);
		y = f - kahan;
		t = sum + y;
		kahan = (t - sum) - y;
		sum = t;
	}
	sum *= 2;
	sum = sum - floor(sum);
	return sum;
}


double calc(int r, method m)
{
	double f;
	double sum = 0.0;
	if (m == kahan) return calc_kahan(r);
	for (int k = 0; k < 512 + r; k++) {
		int n = 2 * k + 1;
		f = frac_3_to_m_div_a(1024 - n, n);
		sum += f;
		if (m == frac) sum = sum - floor(sum);
	}
	sum *= 2;
	sum = sum - floor(sum);
	return sum;
}



double geosum(int from, int to, double q) {
	if (to == INT_MAX) return (pow(q, from) / (1 - q));
	else return (pow(q, from) - pow(q, to + 1)) / (1 - q);
}


int main(int argc, char* argv[])
{

	double minresidual = 0.0;
	double maxresidual;

	int r = 0;

	do {
		int n = 2 * r + 1 + 1024;
		maxresidual = 2.0 / 3.0 / n * geosum(r, INT_MAX, 1.0 / 9.0);
		if (maxresidual < 1e-17) break;
		r++;
	} while (true);

	printf("RC default\n");
	printf("nix   %15.15lf   \n", exp(calc(r, nix)));
	printf("frac  %15.15lf   \n", exp(calc(r, frac)));
	printf("kahan %15.15lf   \n", exp(calc(r, kahan)));

	printf("\nRC_down\n");
	rounddown();
	printf("nix   %15.15lf   \n", exp(calc(r, nix)));
	printf("frac  %15.15lf   \n", exp(calc(r, frac)));
	printf("kahan %15.15lf   \n", exp(calc(r, kahan)));

	printf("\nRC_UP\n");
	roundup();
	printf("nix   %15.15lf   \n", exp(calc(r, nix)));
	printf("frac  %15.15lf   \n", exp(calc(r, frac)));
	printf("kahan %15.15lf   \n", exp(calc(r, kahan)));
	return 0;
}

